/*
 * Decompiled with CFR 0.152.
 */
package redis.server.netty;

import io.netty.buffer.ByteBuf;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import redis.netty4.BulkReply;
import redis.netty4.IntegerReply;
import redis.netty4.MultiBulkReply;
import redis.netty4.Reply;
import redis.netty4.StatusReply;
import redis.server.netty.RedisException;
import redis.server.netty.RedisServer;
import redis.util.BytesKey;
import redis.util.BytesKeyObjectMap;
import redis.util.BytesKeySet;
import redis.util.BytesValue;
import redis.util.Encoding;
import redis.util.ZSet;
import redis.util.ZSetEntry;

public class SimpleRedisServer
implements RedisServer {
    private static final StatusReply PONG = new StatusReply("PONG");
    private long started = this.now();
    private BytesKeyObjectMap<Object> data = new BytesKeyObjectMap();
    private BytesKeyObjectMap<Long> expires = new BytesKeyObjectMap();
    private static int[] mask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static Random r = new SecureRandom();

    private static RedisException invalidValue() {
        return new RedisException("Operation against a key holding the wrong kind of value");
    }

    private static RedisException notInteger() {
        return new RedisException("value is not an integer or out of range");
    }

    private static RedisException notFloat() {
        return new RedisException("value is not a float or out of range");
    }

    private BytesKeyObjectMap<byte[]> _gethash(byte[] key0, boolean create) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            o = new BytesKeyObjectMap();
            if (create) {
                this.data.put(key0, o);
            }
        }
        if (!(o instanceof HashMap)) {
            throw SimpleRedisServer.invalidValue();
        }
        return (BytesKeyObjectMap)o;
    }

    private BytesKeySet _getset(byte[] key0, boolean create) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            o = new BytesKeySet();
            if (create) {
                this.data.put(key0, o);
            }
        }
        if (!(o instanceof BytesKeySet)) {
            throw SimpleRedisServer.invalidValue();
        }
        return (BytesKeySet)o;
    }

    private ZSet _getzset(byte[] key0, boolean create) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            o = new ZSet();
            if (create) {
                this.data.put(key0, o);
            }
        }
        if (!(o instanceof ZSet)) {
            throw SimpleRedisServer.invalidValue();
        }
        return (ZSet)o;
    }

    private Object _get(byte[] key0) {
        Long l;
        Object o = this.data.get(key0);
        if (o != null && (l = (Long)this.expires.get(key0)) != null && l < this.now()) {
            this.data.remove(key0);
            return null;
        }
        return o;
    }

    private IntegerReply _change(byte[] key0, long delta) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            this._put(key0, Encoding.numToBytes((long)delta, (boolean)false));
            return IntegerReply.integer((long)delta);
        }
        if (o instanceof byte[]) {
            try {
                long integer = Encoding.bytesToNum((byte[])((byte[])o)) + delta;
                this._put(key0, Encoding.numToBytes((long)integer, (boolean)false));
                return IntegerReply.integer((long)integer);
            }
            catch (IllegalArgumentException e) {
                throw new RedisException(e.getMessage());
            }
        }
        throw SimpleRedisServer.notInteger();
    }

    private BulkReply _change(byte[] key0, double delta) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            byte[] bytes = this._tobytes(delta);
            this._put(key0, bytes);
            return new BulkReply(bytes);
        }
        if (o instanceof byte[]) {
            try {
                double number = this._todouble((byte[])o) + delta;
                byte[] bytes = this._tobytes(number);
                this._put(key0, bytes);
                return new BulkReply(bytes);
            }
            catch (IllegalArgumentException e) {
                throw new RedisException(e.getMessage());
            }
        }
        throw SimpleRedisServer.notInteger();
    }

    private static int _test(byte[] bytes, long offset) throws RedisException {
        int i;
        long div = offset / 8L;
        if (div > Integer.MAX_VALUE) {
            throw SimpleRedisServer.notInteger();
        }
        if ((long)bytes.length < div + 1L) {
            i = 0;
        } else {
            int mod = (int)(offset % 8L);
            int value = bytes[(int)div] & 0xFF;
            i = value & mask[mod];
        }
        return i != 0 ? 1 : 0;
    }

    private byte[] _getbytes(byte[] aKey2) throws RedisException {
        byte[] src;
        Object o = this._get(aKey2);
        if (o instanceof byte[]) {
            src = (byte[])o;
        } else {
            if (o != null) {
                throw SimpleRedisServer.invalidValue();
            }
            src = new byte[]{};
        }
        return src;
    }

    private List<BytesValue> _getlist(byte[] key0, boolean create) throws RedisException {
        Object o = this._get(key0);
        if (o instanceof List) {
            return (List)o;
        }
        if (o == null) {
            if (create) {
                ArrayList<BytesValue> list = new ArrayList<BytesValue>();
                this._put(key0, list);
                return list;
            }
            return null;
        }
        throw SimpleRedisServer.invalidValue();
    }

    private Object _put(byte[] key, Object value) {
        this.expires.remove(key);
        return this.data.put(key, value);
    }

    private Object _put(byte[] key, byte[] value, long expiration) {
        this.expires.put(key, (Object)expiration);
        return this.data.put(key, (Object)value);
    }

    private static boolean matches(byte[] key, byte[] pattern, int kp, int pp) {
        if (kp == key.length) {
            return pp == pattern.length || pp == pattern.length - 1 && pattern[pp] == 42;
        }
        if (pp == pattern.length) {
            return false;
        }
        byte c = key[kp];
        byte p = pattern[pp];
        switch (p) {
            case 63: {
                return SimpleRedisServer.matches(key, pattern, kp + 1, pp + 1);
            }
            case 42: {
                return SimpleRedisServer.matches(key, pattern, kp + 1, pp + 1) || SimpleRedisServer.matches(key, pattern, kp + 1, pp);
            }
            case 92: {
                return c == pattern[pp + 1] && SimpleRedisServer.matches(key, pattern, kp + 1, pp + 2);
            }
            case 91: {
                boolean found = false;
                while (true) {
                    int n = ++pp;
                    ++pp;
                    byte b = pattern[n];
                    if (b == 93) break;
                    if (b != c) continue;
                    found = true;
                }
                return found && SimpleRedisServer.matches(key, pattern, kp + 1, pp);
            }
        }
        return c == p && SimpleRedisServer.matches(key, pattern, kp + 1, pp + 1);
    }

    private static int _toposint(byte[] offset1) throws RedisException {
        long offset = Encoding.bytesToNum((byte[])offset1);
        if (offset < 0L || offset > Integer.MAX_VALUE) {
            throw SimpleRedisServer.notInteger();
        }
        return (int)offset;
    }

    private static int _toint(byte[] offset1) throws RedisException {
        long offset = Encoding.bytesToNum((byte[])offset1);
        if (offset > Integer.MAX_VALUE) {
            throw SimpleRedisServer.notInteger();
        }
        return (int)offset;
    }

    private static int _torange(byte[] offset1, int length) throws RedisException {
        long offset = Encoding.bytesToNum((byte[])offset1);
        if (offset > Integer.MAX_VALUE) {
            throw SimpleRedisServer.notInteger();
        }
        if (offset < 0L) {
            offset = (long)length + offset;
        }
        if (offset >= (long)length) {
            offset = length - 1;
        }
        return (int)offset;
    }

    private static RedisException noSuchKey() {
        return new RedisException("no such key");
    }

    private long now() {
        return System.currentTimeMillis();
    }

    @Override
    public IntegerReply append(byte[] key0, byte[] value1) throws RedisException {
        Object o = this._get(key0);
        int length1 = value1.length;
        if (o instanceof byte[]) {
            byte[] src = (byte[])o;
            int length0 = src.length;
            byte[] bytes = new byte[length0 + length1];
            System.arraycopy(src, 0, bytes, 0, length0);
            System.arraycopy(value1, 0, bytes, length0, length1);
            this._put(key0, bytes);
            return IntegerReply.integer((long)bytes.length);
        }
        if (o == null) {
            this._put(key0, value1);
            return IntegerReply.integer((long)length1);
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public IntegerReply bitcount(byte[] key0, byte[] start1, byte[] end2) throws RedisException {
        Object o = this._get(key0);
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            int size = bytes.length;
            int s = SimpleRedisServer._torange(start1, size);
            int e = SimpleRedisServer._torange(end2, size);
            if (e < s) {
                e = s;
            }
            int total = 0;
            for (int i = s; i <= e; ++i) {
                int b = bytes[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((b & mask[j]) == 0) continue;
                    ++total;
                }
            }
            return IntegerReply.integer((long)total);
        }
        if (o == null) {
            return IntegerReply.integer((long)0L);
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public IntegerReply bitop(byte[] operation0, byte[] destkey1, byte[][] key2) throws RedisException {
        BitOp bitOp = BitOp.valueOf(new String(operation0).toUpperCase());
        int size = 0;
        for (byte[] aKey2 : key2) {
            int length = aKey2.length;
            if (length <= size) continue;
            size = length;
        }
        byte[] bytes = null;
        for (byte[] aKey2 : key2) {
            int i;
            byte[] src = this._getbytes(aKey2);
            if (bytes == null) {
                bytes = new byte[size];
                if (bitOp == BitOp.NOT) {
                    if (key2.length > 1) {
                        throw new RedisException("invalid number of arguments for 'bitop' NOT operation");
                    }
                    for (i = 0; i < src.length; ++i) {
                        bytes[i] = (byte)(~(src[i] & 0xFF));
                    }
                    continue;
                }
                System.arraycopy(src, 0, bytes, 0, src.length);
                continue;
            }
            block8: for (i = 0; i < src.length; ++i) {
                int d = bytes[i] & 0xFF;
                int s = src[i] & 0xFF;
                switch (bitOp) {
                    case AND: {
                        bytes[i] = (byte)(d & s);
                        continue block8;
                    }
                    case OR: {
                        bytes[i] = (byte)(d | s);
                        continue block8;
                    }
                    case XOR: {
                        bytes[i] = (byte)(d ^ s);
                    }
                }
            }
        }
        this._put(destkey1, bytes);
        return IntegerReply.integer((long)(bytes == null ? 0L : (long)bytes.length));
    }

    @Override
    public IntegerReply decr(byte[] key0) throws RedisException {
        return this._change(key0, -1L);
    }

    @Override
    public IntegerReply decrby(byte[] key0, byte[] decrement1) throws RedisException {
        return this._change(key0, -Encoding.bytesToNum((byte[])decrement1));
    }

    @Override
    public BulkReply get(byte[] key0) throws RedisException {
        Object o = this._get(key0);
        if (o instanceof byte[]) {
            return new BulkReply((byte[])o);
        }
        if (o == null) {
            return BulkReply.NIL_REPLY;
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public IntegerReply getbit(byte[] key0, byte[] offset1) throws RedisException {
        Object o = this._get(key0);
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            long offset = Encoding.bytesToNum((byte[])offset1);
            return SimpleRedisServer._test(bytes, offset) == 1 ? IntegerReply.integer((long)1L) : IntegerReply.integer((long)0L);
        }
        if (o == null) {
            return IntegerReply.integer((long)0L);
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public BulkReply getrange(byte[] key0, byte[] start1, byte[] end2) throws RedisException {
        byte[] bytes = this._getbytes(key0);
        int size = bytes.length;
        int s = SimpleRedisServer._torange(start1, size);
        int e = SimpleRedisServer._torange(end2, size);
        if (e < s) {
            e = s;
        }
        int length = e - s + 1;
        byte[] out = new byte[length];
        System.arraycopy(bytes, s, out, 0, length);
        return new BulkReply(out);
    }

    @Override
    public BulkReply getset(byte[] key0, byte[] value1) throws RedisException {
        Object put = this._put(key0, value1);
        if (put == null || put instanceof byte[]) {
            return put == null ? BulkReply.NIL_REPLY : new BulkReply((byte[])put);
        }
        this.data.put(key0, put);
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public IntegerReply incr(byte[] key0) throws RedisException {
        return this._change(key0, 1L);
    }

    @Override
    public IntegerReply incrby(byte[] key0, byte[] increment1) throws RedisException {
        return this._change(key0, Encoding.bytesToNum((byte[])increment1));
    }

    @Override
    public BulkReply incrbyfloat(byte[] key0, byte[] increment1) throws RedisException {
        return this._change(key0, this._todouble(increment1));
    }

    @Override
    public MultiBulkReply mget(byte[][] key0) throws RedisException {
        int length = key0.length;
        Reply[] replies = new Reply[length];
        for (int i = 0; i < length; ++i) {
            Object o = this._get(key0[i]);
            replies[i] = o instanceof byte[] ? new BulkReply((byte[])o) : BulkReply.NIL_REPLY;
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public StatusReply mset(byte[][] key_or_value0) throws RedisException {
        int length = key_or_value0.length;
        if (length % 2 != 0) {
            throw new RedisException("wrong number of arguments for MSET");
        }
        for (int i = 0; i < length; i += 2) {
            this._put(key_or_value0[i], key_or_value0[i + 1]);
        }
        return StatusReply.OK;
    }

    @Override
    public IntegerReply msetnx(byte[][] key_or_value0) throws RedisException {
        int i;
        int length = key_or_value0.length;
        if (length % 2 != 0) {
            throw new RedisException("wrong number of arguments for MSETNX");
        }
        for (i = 0; i < length; i += 2) {
            if (this._get(key_or_value0[i]) == null) continue;
            return IntegerReply.integer((long)0L);
        }
        for (i = 0; i < length; i += 2) {
            this._put(key_or_value0[i], key_or_value0[i + 1]);
        }
        return IntegerReply.integer((long)1L);
    }

    @Override
    public Reply psetex(byte[] key0, byte[] milliseconds1, byte[] value2) throws RedisException {
        this._put(key0, value2, Encoding.bytesToNum((byte[])milliseconds1) + this.now());
        return StatusReply.OK;
    }

    @Override
    public StatusReply set(byte[] key0, byte[] value1) throws RedisException {
        this._put(key0, value1);
        return StatusReply.OK;
    }

    @Override
    public IntegerReply setbit(byte[] key0, byte[] offset1, byte[] value2) throws RedisException {
        int bit = (int)Encoding.bytesToNum((byte[])value2);
        if (bit != 0 && bit != 1) {
            throw SimpleRedisServer.notInteger();
        }
        Object o = this._get(key0);
        if (o instanceof byte[] || o == null) {
            int mod;
            int value;
            int i;
            long offset = Encoding.bytesToNum((byte[])offset1);
            long div = offset / 8L;
            if (div + 1L > Integer.MAX_VALUE) {
                throw SimpleRedisServer.notInteger();
            }
            byte[] bytes = (byte[])o;
            if (bytes == null || (long)bytes.length < div + 1L) {
                byte[] tmp = bytes;
                bytes = new byte[(int)div + 1];
                if (tmp != null) {
                    System.arraycopy(tmp, 0, bytes, 0, tmp.length);
                }
                this._put(key0, bytes);
            }
            if ((i = (value = bytes[(int)div] & 0xFF) & mask[mod = (int)(offset % 8L)]) == 0) {
                if (bit != 0) {
                    int n = (int)div;
                    bytes[n] = (byte)(bytes[n] + mask[mod]);
                }
                return IntegerReply.integer((long)0L);
            }
            if (bit == 0) {
                int n = (int)div;
                bytes[n] = (byte)(bytes[n] - mask[mod]);
            }
            return IntegerReply.integer((long)1L);
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public StatusReply setex(byte[] key0, byte[] seconds1, byte[] value2) throws RedisException {
        this._put(key0, value2, Encoding.bytesToNum((byte[])seconds1) * 1000L + this.now());
        return StatusReply.OK;
    }

    @Override
    public IntegerReply setnx(byte[] key0, byte[] value1) throws RedisException {
        if (this._get(key0) == null) {
            this._put(key0, value1);
            return IntegerReply.integer((long)1L);
        }
        return IntegerReply.integer((long)0L);
    }

    @Override
    public IntegerReply setrange(byte[] key0, byte[] offset1, byte[] value2) throws RedisException {
        int offset;
        int length;
        byte[] bytes = this._getbytes(key0);
        if (bytes.length < (length = value2.length + (offset = SimpleRedisServer._toposint(offset1)))) {
            byte[] tmp = bytes;
            bytes = new byte[length];
            System.arraycopy(tmp, 0, bytes, 0, offset);
            this._put(key0, bytes);
        }
        System.arraycopy(value2, 0, bytes, offset, value2.length);
        return IntegerReply.integer((long)bytes.length);
    }

    @Override
    public IntegerReply strlen(byte[] key0) throws RedisException {
        return IntegerReply.integer((long)this._getbytes(key0).length);
    }

    public StatusReply auth(byte[] password0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public BulkReply echo(byte[] message0) throws RedisException {
        return new BulkReply(message0);
    }

    @Override
    public StatusReply ping() throws RedisException {
        return PONG;
    }

    @Override
    public StatusReply quit() throws RedisException {
        return StatusReply.QUIT;
    }

    @Override
    public StatusReply select(byte[] index0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public StatusReply bgrewriteaof() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public StatusReply bgsave() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply client_kill(byte[] ip_port0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply client_list() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply client_getname() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply client_setname(byte[] connection_name0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply config_get(byte[] parameter0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply config_set(byte[] parameter0, byte[] value1) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply config_resetstat() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public IntegerReply dbsize() throws RedisException {
        return IntegerReply.integer((long)this.data.size());
    }

    @Override
    public Reply debug_object(byte[] key0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply debug_segfault() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public StatusReply flushall() throws RedisException {
        this.data.clear();
        return StatusReply.OK;
    }

    @Override
    public StatusReply flushdb() throws RedisException {
        this.data.clear();
        return StatusReply.OK;
    }

    @Override
    public BulkReply info(byte[] section) throws RedisException {
        StringBuilder sb = new StringBuilder();
        sb.append("redis_version:2.6.0\n");
        sb.append("keys:").append(this.data.size()).append("\n");
        sb.append("uptime:").append(this.now() - this.started).append("\n");
        return new BulkReply(sb.toString().getBytes());
    }

    @Override
    public IntegerReply lastsave() throws RedisException {
        return IntegerReply.integer((long)-1L);
    }

    @Override
    public Reply monitor() throws RedisException {
        return null;
    }

    @Override
    public Reply save() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public StatusReply shutdown(byte[] NOSAVE0, byte[] SAVE1) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public StatusReply slaveof(byte[] host0, byte[] port1) throws RedisException {
        return null;
    }

    @Override
    public Reply slowlog(byte[] subcommand0, byte[] argument1) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply sync() throws RedisException {
        return null;
    }

    @Override
    public MultiBulkReply time() throws RedisException {
        long millis = System.currentTimeMillis();
        long seconds = millis / 1000L;
        Reply[] replies = new Reply[]{new BulkReply(Encoding.numToBytes((long)seconds)), new BulkReply(Encoding.numToBytes((long)((millis - seconds * 1000L) * 1000L)))};
        return new MultiBulkReply(replies);
    }

    @Override
    public MultiBulkReply blpop(byte[][] key0) throws RedisException {
        return null;
    }

    @Override
    public MultiBulkReply brpop(byte[][] key0) throws RedisException {
        return null;
    }

    @Override
    public BulkReply brpoplpush(byte[] source0, byte[] destination1, byte[] timeout2) throws RedisException {
        return null;
    }

    @Override
    public BulkReply lindex(byte[] key0, byte[] index1) throws RedisException {
        int index = SimpleRedisServer._toposint(index1);
        List<BytesValue> list = this._getlist(key0, true);
        if (list == null || list.size() <= index) {
            return BulkReply.NIL_REPLY;
        }
        return new BulkReply(list.get(index).getBytes());
    }

    @Override
    public IntegerReply linsert(byte[] key0, byte[] where1, byte[] pivot2, byte[] value3) throws RedisException {
        BytesKey pivot;
        Where where = Where.valueOf(new String(where1).toUpperCase());
        List<BytesValue> list = this._getlist(key0, true);
        int i = list.indexOf(pivot = new BytesKey(pivot2));
        if (i == -1) {
            return IntegerReply.integer((long)-1L);
        }
        list.add(i + (where == Where.BEFORE ? 0 : 1), (BytesValue)new BytesKey(value3));
        return IntegerReply.integer((long)list.size());
    }

    @Override
    public IntegerReply llen(byte[] key0) throws RedisException {
        List<BytesValue> list = this._getlist(key0, false);
        return list == null ? IntegerReply.integer((long)0L) : IntegerReply.integer((long)list.size());
    }

    @Override
    public BulkReply lpop(byte[] key0) throws RedisException {
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null || list.size() == 0) {
            return BulkReply.NIL_REPLY;
        }
        return new BulkReply(list.remove(0).getBytes());
    }

    @Override
    public IntegerReply lpush(byte[] key0, byte[][] value1) throws RedisException {
        List<BytesValue> list = this._getlist(key0, true);
        for (byte[] value : value1) {
            list.add(0, (BytesValue)new BytesKey(value));
        }
        return IntegerReply.integer((long)list.size());
    }

    @Override
    public IntegerReply lpushx(byte[] key0, byte[] value1) throws RedisException {
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null) {
            return IntegerReply.integer((long)0L);
        }
        list.add(0, (BytesValue)new BytesKey(value1));
        return IntegerReply.integer((long)list.size());
    }

    @Override
    public MultiBulkReply lrange(byte[] key0, byte[] start1, byte[] stop2) throws RedisException {
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null) {
            return MultiBulkReply.EMPTY;
        }
        int size = list.size();
        int s = SimpleRedisServer._torange(start1, size);
        int e = SimpleRedisServer._torange(stop2, size);
        if (e < s) {
            e = s;
        }
        int length = e - s + 1;
        Reply[] replies = new Reply[length];
        for (int i = s; i <= e; ++i) {
            replies[i - s] = new BulkReply(list.get(i).getBytes());
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public IntegerReply lrem(byte[] key0, byte[] count1, byte[] value2) throws RedisException {
        boolean all;
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null) {
            return IntegerReply.integer((long)0L);
        }
        int count = SimpleRedisServer._toint(count1);
        BytesKey value = new BytesKey(value2);
        int size = list.size();
        int dir = 1;
        int s = 0;
        int e = size;
        int rem = 0;
        boolean bl = all = count == 0;
        if (count < 0) {
            count = -count;
            dir = -1;
            s = e;
            e = -1;
        }
        for (int i = s; (all || count != 0) && i != e; i += dir) {
            if (!list.get(i).equals((Object)value)) continue;
            list.remove(i);
            e -= dir;
            i -= dir;
            ++rem;
            --count;
        }
        return IntegerReply.integer((long)rem);
    }

    @Override
    public StatusReply lset(byte[] key0, byte[] index1, byte[] value2) throws RedisException {
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null) {
            throw SimpleRedisServer.noSuchKey();
        }
        int size = list.size();
        int index = SimpleRedisServer._toposint(index1);
        if (index < size) {
            list.set(index, (BytesValue)new BytesKey(value2));
            return StatusReply.OK;
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public StatusReply ltrim(byte[] key0, byte[] start1, byte[] stop2) throws RedisException {
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null) {
            return StatusReply.OK;
        }
        int l = list.size();
        int s = SimpleRedisServer._torange(start1, l);
        int e = SimpleRedisServer._torange(stop2, l);
        this.data.put(key0, list.subList(s, e + 1));
        return StatusReply.OK;
    }

    @Override
    public BulkReply rpop(byte[] key0) throws RedisException {
        int l;
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null || (l = list.size()) == 0) {
            return BulkReply.NIL_REPLY;
        }
        byte[] bytes = list.get(l - 1).getBytes();
        list.remove(l - 1);
        return new BulkReply(bytes);
    }

    @Override
    public BulkReply rpoplpush(byte[] source0, byte[] destination1) throws RedisException {
        int l;
        List<BytesValue> source = this._getlist(source0, false);
        if (source == null || (l = source.size()) == 0) {
            return BulkReply.NIL_REPLY;
        }
        List<BytesValue> dest = this._getlist(destination1, true);
        BytesValue popped = source.get(l - 1);
        source.remove(l - 1);
        dest.add(0, popped);
        return new BulkReply(popped.getBytes());
    }

    @Override
    public IntegerReply rpush(byte[] key0, byte[][] value1) throws RedisException {
        List<BytesValue> list = this._getlist(key0, true);
        for (byte[] bytes : value1) {
            list.add((BytesValue)new BytesKey(bytes));
        }
        return IntegerReply.integer((long)list.size());
    }

    @Override
    public IntegerReply rpushx(byte[] key0, byte[] value1) throws RedisException {
        List<BytesValue> list = this._getlist(key0, false);
        if (list == null) {
            return IntegerReply.integer((long)0L);
        }
        list.add((BytesValue)new BytesKey(value1));
        return IntegerReply.integer((long)list.size());
    }

    @Override
    public IntegerReply del(byte[][] key0) throws RedisException {
        int total = 0;
        for (byte[] bytes : key0) {
            Object remove = this.data.remove(bytes);
            if (remove != null) {
                ++total;
            }
            this.expires.remove(bytes);
        }
        return IntegerReply.integer((long)total);
    }

    @Override
    public BulkReply dump(byte[] key0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public IntegerReply exists(byte[] key0) throws RedisException {
        Object o = this._get(key0);
        return o == null ? IntegerReply.integer((long)0L) : IntegerReply.integer((long)1L);
    }

    @Override
    public IntegerReply expire(byte[] key0, byte[] seconds1) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return IntegerReply.integer((long)0L);
        }
        this.expires.put(key0, (Object)(Encoding.bytesToNum((byte[])seconds1) * 1000L + this.now()));
        return IntegerReply.integer((long)1L);
    }

    @Override
    public IntegerReply expireat(byte[] key0, byte[] timestamp1) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return IntegerReply.integer((long)0L);
        }
        this.expires.put(key0, (Object)(Encoding.bytesToNum((byte[])timestamp1) * 1000L));
        return IntegerReply.integer((long)1L);
    }

    @Override
    public MultiBulkReply keys(byte[] pattern0) throws RedisException {
        if (pattern0 == null) {
            throw new RedisException("wrong number of arguments for KEYS");
        }
        ArrayList<BulkReply> replies = new ArrayList<BulkReply>();
        Iterator it = this.data.keySet().iterator();
        while (it.hasNext()) {
            BytesKey key = (BytesKey)it.next();
            byte[] bytes = key.getBytes();
            boolean expired = false;
            Long l = (Long)this.expires.get(key);
            if (l != null && l < this.now()) {
                expired = true;
                it.remove();
            }
            if (!SimpleRedisServer.matches(bytes, pattern0, 0, 0) || expired) continue;
            replies.add(new BulkReply(bytes));
        }
        return new MultiBulkReply(replies.toArray(new Reply[replies.size()]));
    }

    @Override
    public StatusReply migrate(byte[] host0, byte[] port1, byte[] key2, byte[] destination_db3, byte[] timeout4) throws RedisException {
        return null;
    }

    @Override
    public IntegerReply move(byte[] key0, byte[] db1) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply object(byte[] subcommand0, byte[][] arguments1) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public IntegerReply persist(byte[] key0) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return IntegerReply.integer((long)0L);
        }
        Long remove = (Long)this.expires.remove(key0);
        return remove == null ? IntegerReply.integer((long)0L) : IntegerReply.integer((long)1L);
    }

    @Override
    public IntegerReply pexpire(byte[] key0, byte[] milliseconds1) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return IntegerReply.integer((long)0L);
        }
        this.expires.put(key0, (Object)(Encoding.bytesToNum((byte[])milliseconds1) + this.now()));
        return IntegerReply.integer((long)1L);
    }

    @Override
    public IntegerReply pexpireat(byte[] key0, byte[] milliseconds_timestamp1) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return IntegerReply.integer((long)0L);
        }
        this.expires.put(key0, (Object)Encoding.bytesToNum((byte[])milliseconds_timestamp1));
        return IntegerReply.integer((long)1L);
    }

    @Override
    public IntegerReply pttl(byte[] key0) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return IntegerReply.integer((long)-1L);
        }
        Long aLong = (Long)this.expires.get(key0);
        if (aLong == null) {
            return IntegerReply.integer((long)-1L);
        }
        return IntegerReply.integer((long)(aLong - this.now()));
    }

    @Override
    public BulkReply randomkey() throws RedisException {
        Set entries = this.data.keySet();
        int n = r.nextInt(entries.size());
        Iterator it = entries.iterator();
        for (int i = 0; it.hasNext() && i < n; ++i) {
            it.next();
        }
        if (it.hasNext()) {
            return new BulkReply(((BytesKey)it.next()).getBytes());
        }
        return null;
    }

    @Override
    public StatusReply rename(byte[] key0, byte[] newkey1) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            throw SimpleRedisServer.noSuchKey();
        }
        this.data.put(newkey1, this.data.remove(key0));
        this.expires.put(newkey1, this.expires.remove(key0));
        return StatusReply.OK;
    }

    @Override
    public IntegerReply renamenx(byte[] key0, byte[] newkey1) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            throw SimpleRedisServer.noSuchKey();
        }
        Object newo = this._get(newkey1);
        if (newo == null) {
            this.data.put(newkey1, this.data.remove(key0));
            this.expires.put(newkey1, this.expires.remove(key0));
            return IntegerReply.integer((long)1L);
        }
        return IntegerReply.integer((long)0L);
    }

    @Override
    public StatusReply restore(byte[] key0, byte[] ttl1, byte[] serialized_value2) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply sort(byte[] key0, byte[][] pattern1_offset_or_count2_pattern3) throws RedisException {
        return null;
    }

    @Override
    public IntegerReply ttl(byte[] key0) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return IntegerReply.integer((long)-1L);
        }
        Long aLong = (Long)this.expires.get(key0);
        if (aLong == null) {
            return IntegerReply.integer((long)-1L);
        }
        return IntegerReply.integer((long)((aLong - this.now()) / 1000L));
    }

    @Override
    public StatusReply type(byte[] key0) throws RedisException {
        Object o = this._get(key0);
        if (o == null) {
            return new StatusReply("none");
        }
        if (o instanceof byte[]) {
            return new StatusReply("string");
        }
        if (o instanceof Map) {
            return new StatusReply("hash");
        }
        if (o instanceof List) {
            return new StatusReply("list");
        }
        if (o instanceof SortedSet) {
            return new StatusReply("zset");
        }
        if (o instanceof Set) {
            return new StatusReply("set");
        }
        return null;
    }

    @Override
    public StatusReply unwatch() throws RedisException {
        return null;
    }

    @Override
    public StatusReply watch(byte[][] key0) throws RedisException {
        return null;
    }

    @Override
    public Reply eval(byte[] script0, byte[] numkeys1, byte[][] key2) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply evalsha(byte[] sha10, byte[] numkeys1, byte[][] key2) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply script_exists(byte[][] script0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply script_flush() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply script_kill() throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public Reply script_load(byte[] script0) throws RedisException {
        throw new RedisException("Not supported");
    }

    @Override
    public IntegerReply hdel(byte[] key0, byte[][] field1) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, false);
        int total = 0;
        for (byte[] hkey : field1) {
            total += hash.remove(hkey) == null ? 0 : 1;
        }
        return IntegerReply.integer((long)total);
    }

    @Override
    public IntegerReply hexists(byte[] key0, byte[] field1) throws RedisException {
        return this._gethash(key0, false).get(field1) == null ? IntegerReply.integer((long)0L) : IntegerReply.integer((long)1L);
    }

    @Override
    public BulkReply hget(byte[] key0, byte[] field1) throws RedisException {
        byte[] bytes = (byte[])this._gethash(key0, false).get(field1);
        if (bytes == null) {
            return BulkReply.NIL_REPLY;
        }
        return new BulkReply(bytes);
    }

    @Override
    public MultiBulkReply hgetall(byte[] key0) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, false);
        int size = hash.size();
        Reply[] replies = new Reply[size * 2];
        int i = 0;
        for (Map.Entry entry : hash.entrySet()) {
            replies[i++] = new BulkReply(((BytesKey)entry.getKey()).getBytes());
            replies[i++] = new BulkReply((byte[])entry.getValue());
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public IntegerReply hincrby(byte[] key0, byte[] field1, byte[] increment2) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, true);
        byte[] field = (byte[])hash.get(field1);
        int increment = SimpleRedisServer._toint(increment2);
        if (field == null) {
            hash.put(field1, (Object)increment2);
            return new IntegerReply((long)increment);
        }
        int i = SimpleRedisServer._toint(field);
        int value = i + increment;
        hash.put(field1, (Object)Encoding.numToBytes((long)value, (boolean)false));
        return new IntegerReply((long)value);
    }

    @Override
    public BulkReply hincrbyfloat(byte[] key0, byte[] field1, byte[] increment2) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, true);
        byte[] field = (byte[])hash.get(field1);
        double increment = this._todouble(increment2);
        if (field == null) {
            hash.put(field1, (Object)increment2);
            return new BulkReply(increment2);
        }
        double d = this._todouble(field);
        double value = d + increment;
        byte[] bytes = this._tobytes(value);
        hash.put(field1, (Object)bytes);
        return new BulkReply(bytes);
    }

    @Override
    public MultiBulkReply hkeys(byte[] key0) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, false);
        int size = hash.size();
        Reply[] replies = new Reply[size];
        int i = 0;
        for (Object hkey : hash.keySet()) {
            replies[i++] = new BulkReply(((BytesKey)hkey).getBytes());
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public IntegerReply hlen(byte[] key0) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, false);
        return IntegerReply.integer((long)hash.size());
    }

    @Override
    public MultiBulkReply hmget(byte[] key0, byte[][] field1) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, false);
        int length = field1.length;
        Reply[] replies = new Reply[length];
        for (int i = 0; i < length; ++i) {
            byte[] bytes = (byte[])hash.get(field1[i]);
            replies[i] = bytes == null ? BulkReply.NIL_REPLY : new BulkReply(bytes);
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public StatusReply hmset(byte[] key0, byte[][] field_or_value1) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, true);
        if (field_or_value1.length % 2 != 0) {
            throw new RedisException("wrong number of arguments for HMSET");
        }
        for (int i = 0; i < field_or_value1.length; i += 2) {
            hash.put(field_or_value1[i], (Object)field_or_value1[i + 1]);
        }
        return StatusReply.OK;
    }

    @Override
    public IntegerReply hset(byte[] key0, byte[] field1, byte[] value2) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, true);
        Object put = hash.put(field1, (Object)value2);
        return put == null ? IntegerReply.integer((long)1L) : IntegerReply.integer((long)0L);
    }

    @Override
    public IntegerReply hsetnx(byte[] key0, byte[] field1, byte[] value2) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, true);
        byte[] bytes = (byte[])hash.get(field1);
        if (bytes == null) {
            hash.put(field1, (Object)value2);
            return IntegerReply.integer((long)1L);
        }
        return IntegerReply.integer((long)0L);
    }

    @Override
    public MultiBulkReply hvals(byte[] key0) throws RedisException {
        BytesKeyObjectMap<byte[]> hash = this._gethash(key0, false);
        int size = hash.size();
        Reply[] replies = new Reply[size];
        int i = 0;
        for (byte[] hvalue : hash.values()) {
            replies[i++] = new BulkReply(hvalue);
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public IntegerReply publish(byte[] channel0, byte[] message1) throws RedisException {
        return null;
    }

    @Override
    public IntegerReply sadd(byte[] key0, byte[][] member1) throws RedisException {
        BytesKeySet set = this._getset(key0, true);
        int total = 0;
        for (byte[] bytes : member1) {
            if (!set.add(bytes)) continue;
            ++total;
        }
        return IntegerReply.integer((long)total);
    }

    @Override
    public IntegerReply scard(byte[] key0) throws RedisException {
        BytesKeySet bytesKeys = this._getset(key0, false);
        return IntegerReply.integer((long)bytesKeys.size());
    }

    @Override
    public MultiBulkReply sdiff(byte[][] key0) throws RedisException {
        BytesKeySet set = this._sdiff(key0);
        return this._setreply(set);
    }

    private BytesKeySet _sdiff(byte[][] key0) throws RedisException {
        BytesKeySet set = null;
        for (byte[] key : key0) {
            if (set == null) {
                set = new BytesKeySet();
                set.addAll((Collection)this._getset(key, false));
                continue;
            }
            BytesKeySet c = this._getset(key, false);
            set.removeAll((Collection)c);
        }
        if (set == null) {
            throw new RedisException("wrong number of arguments for 'sdiff' command");
        }
        return set;
    }

    @Override
    public IntegerReply sdiffstore(byte[] destination0, byte[][] key1) throws RedisException {
        Object o = this._get(destination0);
        if (o == null || o instanceof Set) {
            BytesKeySet set = this._sdiff(key1);
            this._put(destination0, set);
            return IntegerReply.integer((long)set.size());
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public MultiBulkReply sinter(byte[][] key0) throws RedisException {
        BytesKeySet set = this._sinter(key0);
        return this._setreply(set);
    }

    private BytesKeySet _sinter(byte[][] key0) throws RedisException {
        BytesKeySet set = null;
        for (byte[] key : key0) {
            if (set == null) {
                set = this._getset(key, false);
                continue;
            }
            BytesKeySet inter = new BytesKeySet();
            BytesKeySet newset = this._getset(key, false);
            for (BytesKey bytesKey : newset) {
                if (!set.contains((Object)bytesKey)) continue;
                inter.add((Object)bytesKey);
            }
            set = inter;
        }
        if (set == null) {
            throw new RedisException("wrong number of arguments for 'sinter' command");
        }
        return set;
    }

    @Override
    public IntegerReply sinterstore(byte[] destination0, byte[][] key1) throws RedisException {
        Object o = this._get(destination0);
        if (o == null || o instanceof Set) {
            BytesKeySet set = this._sinter(key1);
            this._put(destination0, set);
            return IntegerReply.integer((long)set.size());
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public IntegerReply sismember(byte[] key0, byte[] member1) throws RedisException {
        BytesKeySet set = this._getset(key0, false);
        return set.contains(member1) ? IntegerReply.integer((long)1L) : IntegerReply.integer((long)0L);
    }

    @Override
    public MultiBulkReply smembers(byte[] key0) throws RedisException {
        BytesKeySet set = this._getset(key0, false);
        return this._setreply(set);
    }

    private MultiBulkReply _setreply(BytesKeySet set) {
        Reply[] replies = new Reply[set.size()];
        int i = 0;
        for (BytesKey value : set) {
            replies[i++] = new BulkReply(value.getBytes());
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public IntegerReply smove(byte[] source0, byte[] destination1, byte[] member2) throws RedisException {
        BytesKeySet source = this._getset(source0, false);
        if (source.remove(member2)) {
            BytesKeySet dest = this._getset(destination1, true);
            dest.add(member2);
            return IntegerReply.integer((long)1L);
        }
        return IntegerReply.integer((long)0L);
    }

    @Override
    public BulkReply spop(byte[] key0) throws RedisException {
        BytesKeySet set = this._getset(key0, false);
        if (set.size() == 0) {
            return BulkReply.NIL_REPLY;
        }
        BytesKey key = (BytesKey)set.iterator().next();
        set.remove((Object)key);
        return new BulkReply(key.getBytes());
    }

    @Override
    public Reply srandmember(byte[] key0, byte[] count1) throws RedisException {
        int distinct;
        BytesKeySet set = this._getset(key0, false);
        int size = set.size();
        if (count1 == null) {
            if (size == 0) {
                return BulkReply.NIL_REPLY;
            }
            BytesKey key = (BytesKey)set.iterator().next();
            return new BulkReply(key.getBytes());
        }
        int count = SimpleRedisServer._toint(count1);
        int n = distinct = count < 0 ? -1 : 1;
        if ((count *= distinct) > size && distinct > 0) {
            count = size;
        }
        Reply[] replies = new Reply[count];
        HashSet<BytesKey> found = distinct > 0 ? new HashSet<BytesKey>(count) : null;
        Iterator it = set.iterator();
        for (int i = 0; i < count; ++i) {
            BytesKey key;
            do {
                key = (BytesKey)it.next();
            } while (found != null && !found.add(key));
            replies[i] = new BulkReply(key.getBytes());
        }
        return new MultiBulkReply(replies);
    }

    @Override
    public IntegerReply srem(byte[] key0, byte[][] member1) throws RedisException {
        BytesKeySet set = this._getset(key0, false);
        int total = 0;
        for (byte[] member : member1) {
            if (!set.remove(member)) continue;
            ++total;
        }
        return new IntegerReply((long)total);
    }

    @Override
    public MultiBulkReply sunion(byte[][] key0) throws RedisException {
        BytesKeySet set = this._sunion(key0);
        return this._setreply(set);
    }

    private BytesKeySet _sunion(byte[][] key0) throws RedisException {
        BytesKeySet set = null;
        for (byte[] key : key0) {
            if (set == null) {
                set = new BytesKeySet();
                set.addAll((Collection)this._getset(key, false));
                continue;
            }
            set.addAll((Collection)this._getset(key, false));
        }
        if (set == null) {
            throw new RedisException("wrong number of arguments for 'sunion' command");
        }
        return set;
    }

    @Override
    public IntegerReply sunionstore(byte[] destination0, byte[][] key1) throws RedisException {
        Object o = this._get(destination0);
        if (o == null || o instanceof Set) {
            BytesKeySet set = this._sunion(key1);
            this._put(destination0, set);
            return IntegerReply.integer((long)set.size());
        }
        throw SimpleRedisServer.invalidValue();
    }

    @Override
    public IntegerReply zadd(byte[][] args) throws RedisException {
        if (args.length < 3 || (args.length - 1) % 2 == 1) {
            throw new RedisException("wrong number of arguments for 'zadd' command");
        }
        byte[] key = args[0];
        ZSet zset = this._getzset(key, true);
        int total = 0;
        for (int i = 1; i < args.length; i += 2) {
            byte[] value = args[i + 1];
            byte[] score = args[i];
            if (!zset.add(new BytesKey(value), this._todouble(score))) continue;
            ++total;
        }
        return IntegerReply.integer((long)total);
    }

    private double _todouble(byte[] score) {
        return Double.parseDouble(new String(score));
    }

    @Override
    public IntegerReply zcard(byte[] key0) throws RedisException {
        ZSet zset = this._getzset(key0, false);
        return IntegerReply.integer((long)zset.size());
    }

    @Override
    public IntegerReply zcount(byte[] key0, byte[] min1, byte[] max2) throws RedisException {
        if (key0 == null || min1 == null || max2 == null) {
            throw new RedisException("wrong number of arguments for 'zcount' command");
        }
        ZSet zset = this._getzset(key0, false);
        Score min = this._toscorerange(min1);
        Score max = this._toscorerange(max2);
        List entries = zset.subSet(this._todouble(min1), this._todouble(max2));
        int total = 0;
        for (ZSetEntry entry : entries) {
            if (entry.getScore() == min.value && !min.inclusive || entry.getScore() == max.value && !max.inclusive) continue;
            ++total;
        }
        return IntegerReply.integer((long)total);
    }

    @Override
    public BulkReply zincrby(byte[] key0, byte[] increment1, byte[] member2) throws RedisException {
        ZSet zset = this._getzset(key0, true);
        ZSetEntry entry = zset.get(member2);
        double increment = this._todouble(increment1);
        if (entry == null) {
            zset.add(new BytesKey(member2), increment);
            return new BulkReply(increment1);
        }
        zset.remove(member2);
        zset.add(entry.getKey(), entry.getScore() + increment);
        return new BulkReply(this._tobytes(entry.getScore()));
    }

    @Override
    public IntegerReply zinterstore(byte[] destination0, byte[] numkeys1, byte[][] key2) throws RedisException {
        return this._zstore(destination0, numkeys1, key2, "zinterstore", false);
    }

    private IntegerReply _zstore(byte[] destination0, byte[] numkeys1, byte[][] key2, String name, boolean union) throws RedisException {
        if (destination0 == null || numkeys1 == null) {
            throw new RedisException("wrong number of arguments for '" + name + "' command");
        }
        int numkeys = SimpleRedisServer._toint(numkeys1);
        if (key2.length < numkeys) {
            throw new RedisException("wrong number of arguments for '" + name + "' command");
        }
        int position = numkeys;
        double[] weights = null;
        Aggregate type = null;
        if (key2.length > position) {
            if ("weights".equals(new String(key2[position]).toLowerCase())) {
                if (key2.length < ++position + numkeys) {
                    throw new RedisException("wrong number of arguments for '" + name + "' command");
                }
                weights = new double[numkeys];
                for (int i = position; i < position + numkeys; ++i) {
                    weights[i - position] = this._todouble(key2[i]);
                }
                position += numkeys;
            }
            if (key2.length > position + 1) {
                if ("aggregate".equals(new String(key2[position]).toLowerCase())) {
                    type = Aggregate.valueOf(new String(key2[position + 1]).toUpperCase());
                }
            } else if (key2.length != position) {
                throw new RedisException("wrong number of arguments for '" + name + "' command");
            }
        }
        this.del(new byte[][]{destination0});
        ZSet destination = this._getzset(destination0, true);
        for (int i = 0; i < numkeys; ++i) {
            BytesKey key;
            ZSet zset = this._getzset(key2[i], false);
            if (i == 0) {
                if (weights == null) {
                    destination.addAll(zset);
                    continue;
                }
                double weight = weights[i];
                for (ZSetEntry entry : zset) {
                    destination.add(entry.getKey(), entry.getScore() * weight);
                }
                continue;
            }
            for (ZSetEntry entry : zset) {
                key = entry.getKey();
                ZSetEntry current = destination.get(key);
                destination.remove(key);
                if (!union && current == null) continue;
                double newscore = entry.getScore() * (weights == null ? 1.0 : weights[i]);
                if (type == null || type == Aggregate.SUM) {
                    if (current != null) {
                        newscore += current.getScore();
                    }
                } else if (type == Aggregate.MIN) {
                    if (current != null && newscore > current.getScore()) {
                        newscore = current.getScore();
                    }
                } else if (type == Aggregate.MAX && current != null && newscore < current.getScore()) {
                    newscore = current.getScore();
                }
                destination.add(key, newscore);
            }
            if (union) continue;
            for (ZSetEntry entry : new ZSet(destination)) {
                key = entry.getKey();
                if (zset.get(key) != null) continue;
                destination.remove(key);
            }
        }
        return IntegerReply.integer((long)destination.size());
    }

    @Override
    public MultiBulkReply zrange(byte[] key0, byte[] start1, byte[] stop2, byte[] withscores3) throws RedisException {
        if (key0 == null || start1 == null || stop2 == null) {
            throw new RedisException("invalid number of argumenst for 'zrange' command");
        }
        boolean withscores = this._checkcommand(withscores3, "withscores", true);
        ZSet zset = this._getzset(key0, false);
        int size = zset.size();
        int start = SimpleRedisServer._torange(start1, size);
        int end = SimpleRedisServer._torange(stop2, size);
        Iterator iterator = zset.iterator();
        ArrayList<BulkReply> list = new ArrayList<BulkReply>();
        for (int i = 0; i < size; ++i) {
            if (!iterator.hasNext()) continue;
            ZSetEntry next = (ZSetEntry)iterator.next();
            if (i >= start && i <= end) {
                list.add(new BulkReply(next.getKey().getBytes()));
                if (!withscores) continue;
                list.add(new BulkReply(this._tobytes(next.getScore())));
                continue;
            }
            if (i > end) break;
        }
        return new MultiBulkReply(list.toArray(new Reply[list.size()]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _checkcommand(byte[] check, String command, boolean syntax) throws RedisException {
        if (check == null) return false;
        if (new String(check).toLowerCase().equals(command)) {
            return true;
        }
        if (!syntax) return false;
        throw new RedisException("syntax error");
    }

    @Override
    public MultiBulkReply zrangebyscore(byte[] key0, byte[] min1, byte[] max2, byte[][] withscores_offset_or_count4) throws RedisException {
        ZSet zset = this._getzset(key0, false);
        if (zset.isEmpty()) {
            return MultiBulkReply.EMPTY;
        }
        List<Reply<ByteBuf>> list = this._zrangebyscore(min1, max2, withscores_offset_or_count4, zset, false);
        return new MultiBulkReply(list.toArray(new Reply[list.size()]));
    }

    private List<Reply<ByteBuf>> _zrangebyscore(byte[] min1, byte[] max2, byte[][] withscores_offset_or_count4, ZSet zset, boolean reverse) throws RedisException {
        int position = 0;
        boolean withscores = false;
        if (withscores_offset_or_count4.length > 0) {
            withscores = this._checkcommand(withscores_offset_or_count4[0], "withscores", false);
        }
        if (withscores) {
            ++position;
        }
        boolean limit = false;
        if (withscores_offset_or_count4.length > position) {
            limit = this._checkcommand(withscores_offset_or_count4[position++], "limit", true);
        }
        if (withscores_offset_or_count4.length != position + (limit ? 2 : 0)) {
            throw new RedisException("syntax error");
        }
        int offset = 0;
        int number = Integer.MAX_VALUE;
        if (limit) {
            offset = SimpleRedisServer._toint(withscores_offset_or_count4[position++]);
            number = SimpleRedisServer._toint(withscores_offset_or_count4[position]);
            if (offset < 0 || number < 1) {
                throw SimpleRedisServer.notInteger();
            }
        }
        Score min = this._toscorerange(min1);
        Score max = this._toscorerange(max2);
        List entries = zset.subSet(min.value, max.value);
        if (reverse) {
            Collections.reverse(entries);
        }
        int current = 0;
        ArrayList<Reply<ByteBuf>> list = new ArrayList<Reply<ByteBuf>>();
        for (ZSetEntry entry : entries) {
            if (current >= offset && current < offset + number) {
                list.add((Reply<ByteBuf>)new BulkReply(entry.getKey().getBytes()));
                if (withscores) {
                    list.add((Reply<ByteBuf>)new BulkReply(this._tobytes(entry.getScore())));
                }
            }
            ++current;
        }
        return list;
    }

    private Score _toscorerange(byte[] specifier) {
        Score score = new Score();
        String s = new String(specifier).toLowerCase();
        if (s.startsWith("(")) {
            score.inclusive = false;
            s = s.substring(1);
        }
        score.value = s.equals("-inf") ? Double.NEGATIVE_INFINITY : (s.equals("inf") || s.equals("+inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(s));
        return score;
    }

    @Override
    public Reply zrank(byte[] key0, byte[] member1) throws RedisException {
        List zset = this._getzset(key0, false).list();
        return this._zrank(member1, zset);
    }

    @Override
    public IntegerReply zrem(byte[] key0, byte[][] member1) throws RedisException {
        ZSet zset = this._getzset(key0, false);
        if (zset.isEmpty()) {
            return IntegerReply.integer((long)0L);
        }
        int total = 0;
        for (byte[] member : member1) {
            if (!zset.remove(member)) continue;
            ++total;
        }
        return IntegerReply.integer((long)total);
    }

    @Override
    public IntegerReply zremrangebyrank(byte[] key0, byte[] start1, byte[] stop2) throws RedisException {
        ZSet zset = this._getzset(key0, false);
        if (zset.isEmpty()) {
            return IntegerReply.integer((long)0L);
        }
        int size = zset.size();
        int start = SimpleRedisServer._torange(start1, size);
        int end = SimpleRedisServer._torange(stop2, size);
        Iterator iterator = zset.iterator();
        ArrayList<ZSetEntry> list = new ArrayList<ZSetEntry>();
        for (int i = 0; i < size; ++i) {
            if (!iterator.hasNext()) continue;
            ZSetEntry next = (ZSetEntry)iterator.next();
            if (i >= start && i <= end) {
                list.add(next);
                continue;
            }
            if (i > end) break;
        }
        int total = 0;
        for (ZSetEntry zSetEntry : list) {
            if (!zset.remove(zSetEntry.getKey())) continue;
            ++total;
        }
        return IntegerReply.integer((long)total);
    }

    @Override
    public IntegerReply zremrangebyscore(byte[] key0, byte[] min1, byte[] max2) throws RedisException {
        ZSet zset = this._getzset(key0, false);
        if (zset.isEmpty()) {
            return IntegerReply.integer((long)0L);
        }
        Score min = this._toscorerange(min1);
        Score max = this._toscorerange(max2);
        List entries = zset.subSet(min.value, max.value);
        int total = 0;
        for (ZSetEntry entry : new ArrayList(entries)) {
            if (!min.inclusive && entry.getScore() == min.value || !max.inclusive && entry.getScore() == max.value || !zset.remove(entry.getKey())) continue;
            ++total;
        }
        return IntegerReply.integer((long)total);
    }

    @Override
    public MultiBulkReply zrevrange(byte[] key0, byte[] start1, byte[] stop2, byte[] withscores3) throws RedisException {
        if (key0 == null || start1 == null || stop2 == null) {
            throw new RedisException("invalid number of argumenst for 'zrevrange' command");
        }
        boolean withscores = this._checkcommand(withscores3, "withscores", true);
        ZSet zset = this._getzset(key0, false);
        int size = zset.size();
        int end = size - SimpleRedisServer._torange(start1, size) - 1;
        int start = size - SimpleRedisServer._torange(stop2, size) - 1;
        Iterator iterator = zset.iterator();
        ArrayList<BulkReply> list = new ArrayList<BulkReply>();
        for (int i = 0; i < size; ++i) {
            if (!iterator.hasNext()) continue;
            ZSetEntry next = (ZSetEntry)iterator.next();
            if (i >= start && i <= end) {
                list.add(0, new BulkReply(next.getKey().getBytes()));
                if (!withscores) continue;
                list.add(1, new BulkReply(this._tobytes(next.getScore())));
                continue;
            }
            if (i > end) break;
        }
        return new MultiBulkReply(list.toArray(new Reply[list.size()]));
    }

    @Override
    public MultiBulkReply zrevrangebyscore(byte[] key0, byte[] max1, byte[] min2, byte[][] withscores_offset_or_count4) throws RedisException {
        ZSet zset = this._getzset(key0, false);
        if (zset.isEmpty()) {
            return MultiBulkReply.EMPTY;
        }
        List<Reply<ByteBuf>> list = this._zrangebyscore(min2, max1, withscores_offset_or_count4, zset, true);
        return new MultiBulkReply(list.toArray(new Reply[list.size()]));
    }

    @Override
    public Reply zrevrank(byte[] key0, byte[] member1) throws RedisException {
        List zset = this._getzset(key0, false).list();
        Collections.reverse(zset);
        return this._zrank(member1, zset);
    }

    private Reply _zrank(byte[] member1, List<ZSetEntry> zset) {
        BytesKey member = new BytesKey(member1);
        int position = 0;
        for (ZSetEntry entry : zset) {
            if (entry.getKey().equals((Object)member)) {
                return IntegerReply.integer((long)position);
            }
            ++position;
        }
        return BulkReply.NIL_REPLY;
    }

    @Override
    public BulkReply zscore(byte[] key0, byte[] member1) throws RedisException {
        ZSet zset = this._getzset(key0, false);
        ZSetEntry entry = zset.get(member1);
        double score = entry.getScore();
        return new BulkReply(this._tobytes(score));
    }

    private byte[] _tobytes(double score) {
        return String.valueOf(score).getBytes();
    }

    @Override
    public IntegerReply zunionstore(byte[] destination0, byte[] numkeys1, byte[][] key2) throws RedisException {
        return this._zstore(destination0, numkeys1, key2, "zunionstore", true);
    }

    static class Score {
        boolean inclusive = true;
        double value;

        Score() {
        }
    }

    static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }

    static enum Where {
        BEFORE,
        AFTER;

    }

    static enum BitOp {
        AND,
        OR,
        XOR,
        NOT;

    }
}

