/*
 * Decompiled with CFR 0.152.
 */
package redis.server.netty;

import com.google.common.base.Charsets;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import redis.netty4.Command;
import redis.netty4.ErrorReply;
import redis.netty4.InlineReply;
import redis.netty4.Reply;
import redis.netty4.StatusReply;
import redis.server.netty.RedisException;
import redis.server.netty.RedisServer;
import redis.util.BytesKey;

@ChannelHandler.Sharable
public class RedisCommandHandler
extends ChannelInboundHandlerAdapter {
    private Map<BytesKey, Wrapper> methods = new HashMap<BytesKey, Wrapper>();
    private static final byte LOWER_DIFF = 32;

    public RedisCommandHandler(final RedisServer rs) {
        Class<?> aClass = rs.getClass();
        for (final Method method : aClass.getMethods()) {
            final Class[] types = method.getParameterTypes();
            this.methods.put(new BytesKey(method.getName().getBytes()), new Wrapper(){

                @Override
                public Reply execute(Command command) throws RedisException {
                    Object[] objects = new Object[types.length];
                    try {
                        command.toArguments(objects, types);
                        return (Reply)method.invoke((Object)rs, objects);
                    }
                    catch (IllegalAccessException e) {
                        throw new RedisException("Invalid server implementation");
                    }
                    catch (InvocationTargetException e) {
                        Throwable te = e.getTargetException();
                        if (!(te instanceof RedisException)) {
                            te.printStackTrace();
                        }
                        return new ErrorReply("ERR " + te.getMessage());
                    }
                    catch (Exception e) {
                        return new ErrorReply("ERR " + e.getMessage());
                    }
                }
            });
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
        super.channelReadComplete(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object _msg) throws Exception {
        Command msg = (Command)_msg;
        byte[] name = msg.getName();
        for (int i = 0; i < name.length; ++i) {
            byte b = name[i];
            if (b < 65 || b > 90) continue;
            name[i] = (byte)(b + 32);
        }
        Wrapper wrapper = this.methods.get(new BytesKey(name));
        Object reply = wrapper == null ? new ErrorReply("unknown command '" + new String(name, Charsets.US_ASCII) + "'") : wrapper.execute(msg);
        if (reply == StatusReply.QUIT) {
            ctx.close();
        } else {
            if (msg.isInline()) {
                reply = reply == null ? new InlineReply(null) : new InlineReply(reply.data());
            }
            if (reply == null) {
                reply = ErrorReply.NYI_REPLY;
            }
            ctx.write(reply);
        }
    }

    static interface Wrapper {
        public Reply execute(Command var1) throws RedisException;
    }
}

