(ns clojusc.test-reporter
  (:require [clojure.java.io :as io]
            [clojure.test :as test])
  (:refer-clojure :exclude [test]))

;; Override the :fail report type
(defmethod test/report :fail [m]
  (test/inc-report-counter :fail)
  (println "CUSTOM FAIL REPORT:")
  (println "Expected:" (:expected m))
  (println "Actual:  " (:actual m))
  (when-let [message (:message m)]
    (println "Message: " message))
  (println "---"))

;; Override the :pass report type
(defmethod test/report :pass [m]
  (test/inc-report-counter :pass)
;  (print "✓")
  )

;; Override other event types as needed
(defmethod test/report :error [m]
  (test/inc-report-counter :error)
  (println "Error:" (:var m)))

(defmethod test/report :begin-test-var [m]
  (println "Starting test:" (:var m)))

(defmethod test/report :end-test-var [m]
  (println "Finished test:" (:var m)))

(defmethod test/report :begin-test-ns [m]
  (println "Starting ns:" (:var m)))

(defmethod test/report :end-test-ns [m]
  (println "Finished ns:" (:var m)))