package kroo.jetty_utils;

import clojure.lang.IFn;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DecoratingHandlerWrapper extends HandlerWrapper {
    private final IFn decorator;

    /**
     * @param decorator should take the same 4 parameters as the handle method, in the same order
     */
    public DecoratingHandlerWrapper(IFn decorator) {
        this.decorator = decorator;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.handle(target, baseRequest, request, response);
        decorator.invoke(target, baseRequest, request, response);
    }
}
