(ns com.ginger.cljs.views.welcome
  (:require [com.ginger.cljs.views.common :as common])
  (:use [noir.core :only [defpage]] [hiccup.core :only [html]]))

(defpage "/" []
  (common/layout
    [:header {"class" "jumbotron subhead" "id" "overview"}
     [:h1 "Welcome to Cloujsearch"] 
     [:p {"class" "lead"} 
      "A Clojure based API library and front end to "
      [:a {"href" "http://aws.amazon.com/cloudsearch/"} "Cloudsearch"]]] 
    [:section {"id" "features"}
     [:div {:class "page-header"} [:h2 "Features:"] ]
     [:ul 
      [:li  "Uploading documents into the Cloudsearch index (see example)"] 
      [:li  "Search documents from the Cloudsearch index"]
      [:li  "Managing indexed fields, domains and access restriction."]
      ]] 


    [:a {"class" "btn btn-primary btn-large" "href" "/search"} "Search Documents" ]
    ))
