(ns com.ginger.cljs.views.common
  (:use [noir.core :only [defpartial]]
        [hiccup.page-helpers :only [include-css include-js html5]]))

(defpartial layout [& content]
            (html5
              [:head
               [:title "Cloujsearch"]
               (include-css "/css/bootstrap.css")
               (include-css "/css/bootstrap-responsive.css")
               [:style "body { padding-top: 60px; }"]]
              [:body
               (list
                [:div.navbar.navbar-fixed-top {"data-toggle" "collapse" "data-target" ".nav-collapse"}
                 [:div.navbar-inner
                  [:div.container
                   [:a.btn.btn-navbar
                    [:span.icon-bar]]
                  [:a.brand "Cloujsearch"]
                   [:div.nav-collapse
                    [:ul.nav
                     [:li.active
                      [:a {"href" "/"} "Home"]]
                     [:li
                      [:a {"href" "/search"} "Run search"]]
                     [:li
                      [:a {"href" "https://github.com/gingersoftware/cloujsearch/blob/master/examples/com/ginger/cljs/basic.clj"} "API Example"]]
                    
                    [:li
                      [:a {"href"  "http://docs.amazonwebservices.com/cloudsearch/latest/developerguide/SvcIntro.html"} "AWS Docs"]]
                     [:li
                      [:a {"href"  "https://github.com/gingersoftware/cloujsearch"} "Source"]]]]]]]
                [:div.container content] 
                (include-js "http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js")
                (include-js "/js/bootstrap.min.js")
                (include-js "/js/jquery.min.js")
                 )]))
