(ns com.ginger.cljs.search
  (:use 
    [com.ginger.cljs.http :only (http-request con-mgr)]
    [clojure.string :only (join)]
    [clojure.data.json :only  (read-json json-str)]
    [cheshire.core :only (parse-string)]
    ) 
  (:require 
    [clj-http.conn-mgr :as http-con-mgr] 
    ))

(def search-endpoint ".us-east-1.cloudsearch.amazonaws.com/2011-02-01/search")

(def ^:dynamic *point* "kuku-3746kkv44fpjmvgqwmswkpevwe")

(defn search-request [point params]
  {:test (doc-request (sdf-req))}
  (binding [http-con-mgr/*connection-manager* con-mgr]
   (let [url (str "http://doc-" point search-endpoint) five-min (* 1000 60 5)]
     (parse-string
       (:body 
          (http-request 
                {:url url :method :get :query-params params })) true))))


