(ns com.ginger.cljs.http
  (:use 
    [clojure.string :only (join)]
    [clojure.data.json :only  (read-json json-str)])
  (:require 
    [clj-http.conn-mgr :as http-con-mgr] 
    [clj-http.client :as http-client]
    [clj-http.core :as http-core]
    ))

(def con-mgr  (http-con-mgr/make-reusable-conn-manager  {:timeout 5}))

(def http-request 
     "Default request intercepts errors, this way we skip it"
     (-> #'http-core/request
            http-client/wrap-input-coercion http-client/wrap-output-coercion
            http-client/wrap-query-params 
            http-client/wrap-accept-encoding http-client/wrap-content-type
            http-client/wrap-method http-client/wrap-url))

