(ns com.ginger.cljs.doc
  (:use 
    [com.ginger.cljs.http :only (http-request con-mgr)]
    [clojure.string :only (join)]
    [clojure.data.json :only  (read-json json-str)])
  (:require 
    [clj-http.conn-mgr :as http-con-mgr] 
    ))

(defn gen-id [] (-> (java.util.UUID/randomUUID) str (.replaceAll "-" "")))

(defn sdf-req []
  [{:type "add" :id  "f1243" :version 1 :lang "en"
    :fields {:txt "The Seeker: The Dark Is Rising" :a "1" :b "1" }}])

(defn add-req 
  ^{:pre [(number? version)]} 
  [{:keys [id version lang fields] :or {lang "en" id (gen-id)} :as sdf}]
  "Creates an sdf add requests, land and id will get default values if not provided"
  (merge sdf {:type "add" :id id :version version :lang lang}) )


(def docs-endpoint ".us-east-1.cloudsearch.amazonaws.com/2011-02-01/documents/batch")

(def max-batch "5MB" 5242880)

(def ^:dynamic *point* "kuku-3746kkv44fpjmvgqwmswkpevwe")

(defn doc-request [point sdf]
  {:test (doc-request (sdf-req))}
  (let [url (str "http://doc-" point docs-endpoint) five-min (* 1000 60 5)]
    (http-request 
      {:url url :body sdf :method :post :content-type "application/json" 
       :conn-timeout five-min :socket-timeout five-min})))

(defn update-vals [dest vals]
  (reduce (fn [r [k v f]]  (update-in r k f v)) dest vals))

(defn 
  ^{:test #(assert (= [{:size 2, :sdf ["{}"]}] (append-batch [{:size 0 :sdf []}] "{}")))}
  append-batch [bs ^String req]
  (let [size (.length req)]
    (if (>= (+ size (-> bs peek :size)) max-batch)
      (conj  bs {:size size :sdf [req]}) 
      (conj (pop bs) (update-vals (peek bs) [[[:sdf] req conj] [[:size] size +]] )))))


(defn batches [requests]
  (reduce append-batch [{:size 0 :sdf []}] requests))

(defn process-batches [batch-seq]
  "Processes a sequence of sdf requests forming partitioning into batches and sending away"
  (binding [http-con-mgr/*connection-manager* con-mgr]
    (doall 
      (map deref 
           (for [batch batch-seq]
             (future (doc-request *point* (str "[" (join "," (batch :sdf)) "]"))))))))
