(defproject com.ginger/cloujsearch "0.1.0"
  :description "An api and front end to AWS cloudsearch"
  :url "https://github.com/gingersoftware/cloujsearch"
  :license {:name "Apache V2"
            :url "http://www.apache.org/licenses/LICENSE-2.0.html"}
  :dependencies [
                 [cheshire "4.0.0"] 
                 [org.clojure/clojure "1.3.0"]
                 [org.clojure/data.json "0.1.2"]
                 [org.apache.httpcomponents/httpclient "4.1.1"] ; aws-java-sdk-1.3.3 not specify
                 [com.amazonaws/aws-java-sdk "1.3.11" 
                  :exclusions  [javax.mail/mail org.apache.httpcomponents/httpclient]]
                 [clj-http "0.4.3"]
                 [noir "1.2.1"]
                 ]

  :test-paths  ["test" "examples"]

  :profiles  {:dev {:dependencies [[org.mockito/mockito-all "1.9.0"]]}}

  :plugins [[perforate "0.2.3"] [lein-tarsier "0.9.1"]]

  :test-selectors  {:default  (complement :integration)
                    :integration :integration
                    :all  (fn  [_] true)}

  :main com.ginger.cljs.server
  )
