/*
 * Decompiled with CFR 0.152.
 */
package com.geekvivek.jmx.utils.service;

import com.geekvivek.jmx.utils.JmxMetric;
import com.geekvivek.jmx.utils.exceptions.EmptyJmxMetricListenerListException;
import com.geekvivek.jmx.utils.interfaces.JmxMetricsListener;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricProviderService
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JmxMetricProviderService.class);
    private static final AtomicInteger FACTORY_ID = new AtomicInteger();
    private final ScheduledExecutorService executor;
    private final MBeanServer server;
    private final List<JmxMetricsListener> metricsUpdateListeners;
    private final HashMap<ObjectName, List<JmxMetric>> metricsCache;
    private final Set<String> primitiveTypes = new HashSet<String>(Arrays.asList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void"));
    private final Set<String> numberTypes = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "float", "double"));

    public JmxMetricProviderService(List<JmxMetricsListener> metricsUpdateListeners) {
        this(metricsUpdateListeners, Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("" + FACTORY_ID.incrementAndGet())));
    }

    public JmxMetricProviderService(List<JmxMetricsListener> metricsUpdateListeners, ScheduledExecutorService executor) {
        this.executor = executor;
        this.metricsUpdateListeners = metricsUpdateListeners;
        this.metricsCache = new HashMap();
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    public void start(long initialDelay, long period, TimeUnit unit) throws EmptyJmxMetricListenerListException {
        if (this.metricsUpdateListeners == null || this.metricsUpdateListeners.size() == 0) {
            throw new EmptyJmxMetricListenerListException();
        }
        this.executor.scheduleAtFixedRate(() -> {
            try {
                this.checkForMetricsUpdate();
            }
            catch (Exception ex) {
                LOG.error("Exception thrown from #report. Exception was suppressed.", (Throwable)ex);
            }
        }, initialDelay, period, unit);
    }

    private void checkForMetricsUpdate() {
        Set<ObjectName> mbeans = this.server.queryNames(null, null);
        HashSet<ObjectName> remaining = new HashSet<ObjectName>(this.metricsCache.keySet());
        for (ObjectName mbean : mbeans) {
            if (this.metricsCache.containsKey(mbean)) {
                remaining.remove(mbean);
                continue;
            }
            try {
                List<JmxMetric> metrics = this.getMetricsForMBean(mbean);
                this.metricsCache.put(mbean, metrics);
                LOG.debug("Metrics : {}", (Object)metrics.toString());
                metrics.forEach(metric -> this.metricsUpdateListeners.forEach(listener -> listener.metricChange((JmxMetric)metric)));
            }
            catch (JMException e) {
                LOG.error("Exception in registering for MBean {}", (Object)mbean, (Object)e);
            }
        }
        for (ObjectName mbean : remaining) {
            this.metricsCache.get(mbean).forEach(metric -> this.metricsUpdateListeners.forEach(listener -> listener.metricRemoval((JmxMetric)metric)));
            this.metricsCache.remove(mbean);
        }
    }

    private List<JmxMetric> getMetricsForMBean(ObjectName mbean) throws JMException {
        MBeanAttributeInfo[] attrInfo = this.server.getMBeanInfo(mbean).getAttributes();
        return Arrays.stream(attrInfo).filter(attr -> this.isNumber(attr.getType())).map(attr -> new JmxMetric(mbean, (MBeanAttributeInfo)attr, this.server)).collect(Collectors.toList());
    }

    private boolean isNumber(String type) {
        if (this.primitiveTypes.contains(type)) {
            return this.numberTypes.contains(type);
        }
        try {
            Class<?> cls = Class.forName(type);
            return Number.class.isAssignableFrom(cls);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void stop() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    System.err.println(this.getClass().getSimpleName() + ": ScheduledExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "jxm-metric-provider-service-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

