/*
 * Decompiled with CFR 0.152.
 */
package com.geekvivek.jmx.utils;

import com.geekvivek.jmx.utils.exceptions.MetricNotAvailableException;
import java.util.Map;
import java.util.Objects;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JmxMetric {
    private final String domain;
    private final String type;
    private final String name;
    private final Map<String, String> tags;
    private final String meterName;
    private final ObjectName mBeanObjectName;
    private final MBeanServer mBeanServer;

    public JmxMetric(ObjectName mBeanObjectName, MBeanAttributeInfo attributeInfo, MBeanServer mBeanServer) {
        this.mBeanObjectName = mBeanObjectName;
        this.mBeanServer = mBeanServer;
        this.domain = mBeanObjectName.getDomain();
        this.tags = mBeanObjectName.getKeyPropertyList();
        this.type = this.tags.remove("type");
        this.name = this.tags.remove("name");
        this.meterName = attributeInfo.getName();
    }

    public Object getValue() throws MetricNotAvailableException {
        try {
            return this.mBeanServer.getAttribute(this.mBeanObjectName, this.meterName);
        }
        catch (JMException e) {
            throw new MetricNotAvailableException("metric : " + this.mBeanObjectName + " is not available now");
        }
    }

    public void addNotificationListener(NotificationListener listener, Object context) throws InstanceNotFoundException {
        this.mBeanServer.addNotificationListener(this.mBeanObjectName, listener, null, context);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException, InstanceNotFoundException {
        this.mBeanServer.removeNotificationListener(this.mBeanObjectName, listener);
    }

    public int hashCode() {
        return Objects.hash(this.mBeanObjectName, this.meterName);
    }

    public String toString() {
        if ("Value".equals(this.meterName) || "Number".equals(this.meterName)) {
            return this.mBeanObjectName.toString();
        }
        return this.mBeanObjectName.toString() + "." + this.meterName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getMeterName() {
        return this.meterName;
    }
}

