/*
 * Decompiled with CFR 0.152.
 */
package com.gabber;

import com.flipkart.ranger.model.ServiceNode;
import com.gabber.BroadcastFeature;
import com.gabber.HttpUtils;
import com.gabber.ReflectionUtils;
import com.gabber.RequestModel;
import com.gabber.ShouldBroadcastFilter;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.discovery.bundle.ServiceDiscoveryBundle;
import io.dropwizard.discovery.common.ShardInfo;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BroadcastrBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(BroadcastrBundle.class);
    private ServiceDiscoveryBundle bundle;

    public void run(T configuration, Environment environment) throws Exception {
        this.bundle = this.getServiceDiscovery();
        ShouldBroadcastFilter filter = new ShouldBroadcastFilter(this.bundle);
        environment.jersey().register((Object)new BroadcastFeature(filter));
    }

    public abstract ServiceDiscoveryBundle getServiceDiscovery();

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public <T> T broadcastr(Class<T> clazz) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(clazz);
        factory.setFilter(method -> true);
        return (T)factory.create(new Class[0], new Object[0], this.getProxyMethodHandler());
    }

    public MethodHandler getProxyMethodHandler() {
        return (self, thisMethod, proceed, args) -> {
            RequestModel model = ReflectionUtils.generateModel(thisMethod, args);
            if (model.isJson()) {
                Client client = ClientBuilder.newClient();
                String typePath = thisMethod.getDeclaringClass().getAnnotation(Path.class).value();
                String query = HttpUtils.serializeQueryMap(model.getQueries());
                String pathWithQuery = String.format("%s%s?%s", typePath, model.getPath(), query);
                List ans = this.getServiceDiscovery().getServiceDiscoveryClient().getAllNodes().stream().map(node -> {
                    String hostPort = HttpUtils.hostPortString((ServiceNode<ShardInfo>)node);
                    String api = String.format("%s%s%s?%s", hostPort, pathWithQuery);
                    log.info("Api {}", (Object)api);
                    try {
                        Response response = HttpUtils.getResponse(thisMethod, model, client, api);
                        return ShouldBroadcastFilter.Data.builder().status(response.getStatus()).host(hostPort).data(HttpUtils.readResponseObject(response)).build();
                    }
                    catch (Exception e) {
                        return ShouldBroadcastFilter.Data.builder().status(500).data(e.getMessage()).build();
                    }
                }).collect(Collectors.toList());
                return Response.ok(ans).build();
            }
            return null;
        };
    }
}

