(defproject com.fzakaria/slf4j-timbre "0.2.2"
  :description "SLF4J binding for Timbre"
  :url "https://github.com/fzakaria/slf4j-timbre"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [com.taoensso/timbre "4.1.4"]
                 [org.slf4j/slf4j-api "1.7.12"]]

  :plugins [[lein-ancient "0.6.5"]]

  :profiles {:dev {:dependencies [[midje "1.8.1"]]
                   :plugins [[lein-midje "3.2"]]}}

  :source-paths ["src/clj"]

  :java-source-paths ["src/java"]
  :javac-options ["-target" "1.7" "-source" "1.7" "-Xlint:-options"]

  :prep-tasks ["compile" "javac"]

  :aot :all

  :scm {:name "git"
        :url "https://github.com/fzakaria/slf4j-timbre"}

  )