(ns winst.routes
  (:use [clojure.contrib.def :only (defvar-)]
        [compojure.core :only (routes GET)]
        [compojure.route :only (resources not-found)]
        [compojure.handler :only (site)]
        [hiccup.middleware :only (wrap-base-url)]
        [winst.handlers :only
         (holdings-handler activities-handler gains-handler)]
        [winst.presentation :only (render-not-found)]))

(defvar- re-account #"[a-zA-Z][a-zA-Z0-9]*")

(defvar- re-year #"20[0-9]{2}")

(defvar- re-month #"0?[1-9]|1[012]")

(defn main-routes [accounts]
  (let [accounts (apply hash-map (mapcat (fn [a] [(:tag a) a]) accounts))
        handle-holdings (holdings-handler accounts)
        handle-activities (activities-handler accounts)
        handle-gains (gains-handler accounts)
        rts (routes
             (GET ["/accounts/:account/holdings/:year/:month"
                   :account re-account :year re-year :month re-month] _
                  handle-holdings)

             (GET ["/accounts/:account/holdings/:year"
                   :account re-account :year re-year] _ handle-holdings)

             (GET ["/accounts/:account/holdings" :account re-account] _
                  handle-holdings)

             (GET ["/accounts/:account/activities/:year/:month"
                   :account re-account :year re-year :month re-month] _
                  handle-activities)

             (GET ["/accounts/:account/activities/:year"
                   :account re-account :year re-year] _ handle-activities)

             (GET ["/accounts/:account/activities" :account re-account] _
                  handle-activities)

             (GET ["/accounts/:account/gains/:year/:month"
                   :account re-account :year re-year :month re-month] _
                  handle-gains)

             (GET ["/accounts/:account/gains/:year"
                   :account re-account :year re-year] _ handle-gains)

             (GET ["/accounts/:account/gains" :account re-account] _
                  handle-gains)

             (resources "/")

             (not-found (render-not-found)))]
    (-> rts site wrap-base-url)))

