;; Copyright (c) George Lipov. All rights reserved.
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 2.0 (https://choosealicense.com/licenses/epl-2.0/)
;; which can be found in the file LICENSE at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by
;; the terms of this license.
;; You must not remove this notice, or any other, from this software.

(ns ^:no-doc com.fulcrologic.guardrails.utils)

(defn cljs-env? [env] (boolean (:ns env)))

#?(:clj
   (defn hint-backtrace ^"[Ljava.lang.Object;"
     [backtrace]
     backtrace)
   :cljs
   (defn hint-backtrace
     [backtrace]
     backtrace))

(defn get-ns-meta [env])

(defn get-ns-name [env])

(defn clj->cljs
  ([form])
  ([form strip-core-ns]))


(defn get-file-position [env])


(defn get-call-context
  ([env])
  ([env label]))

(defn gen-exception [env msg])
(defn devtools-config-override [])
(defn map-vals [f m])
(defn map-keys [f m])
(defn filter-vals [pred m])

#?(:clj
   (defn atom? [x])
   :cljs
   (defn ^boolean atom? [x]))

#?(:clj
   (defn compiling-cljs?
     "Return truthy iff currently generating Cljs code."
     []
     ))

(defn stacktrace
  "Get a string that represents the full stack trace"
  ([err])
  ([err opts]))

(let [ansi-color-regex #"\033\[[0-9;]*m"]
  )

#?(:clj
   (def ^:dynamic *stacktrace-filters* nil))

(defn stack-trace
  "Returns a vector of a Clojure-oriented stack trace of tr a Throwable/Exception. In CLJS this is just `(vector tr)`."
  ([tr])
  ([tr prune?]))

(declare current-backtrace)
(declare backtrace-entry-function)
(declare backtrace-entry-args)

(defn report-info [message])

(def -last-failure-map)
(defn last-failure
  "Returns the stack trace of the most recent GR failure for the fully-qualified function name (string or symbol)
   `fnsym`.  `prune?` (default true) indicates that it should remove frames that appear to be uninteresting noise."
  ([fnsym])
  ([fnsym prune?]))

(defn record-failure [str-or-sym e]
  )

(defn backtrace-str []
  )

(defn problem-description [message callsite-ex {stack-trace-option :guardrails/stack-trace
                                                :guardrails/keys   [fqnm trace?] :as options}]
  )

(defn report-problem
  ([message])
  ([message callsite-ex {stack-trace-option :guardrails/stack-trace
                         :guardrails/keys   [fqnm trace?] :as options}]
   ))

(defn report-exception [e message]
  )

(def ^:dynamic *backtrace* nil)

(defn backtrace-entry
  ([] [])
  ([nspc nm args] [nspc nm args]))

(def empty-entry (backtrace-entry))

(defn new-backtrace
  ([])
  ([sz]))

(defn backtrace-enter
  [nspc nm & args]
  )

(defn backtrace-exit []
  )

(defn backtrace-entry-function
  "Returns the function called in the given backtrace entry, or nil if the entry is nil/empty"
  [backtrace-entry]
  )

(defn backtrace-entry-args
  "Returns the arguments passed to the call in the backtrace entry, or nil if empty"
  [backtrace-entry]
  )

(defn current-backtrace
  "Returns a vector of maps for the current backtrace."
  []
  )
