(ns com.fulcrologic.guardrails.malli.core
  #?(:cljs (:require-macros com.fulcrologic.guardrails.malli.core)))

;;; Operators ;;;

(def => :ret)
(def | :st)
(def <- :gen)

#?(:clj (defmacro ? [& forms]))


(def ^:dynamic *coll-check-limit* nil)

#?(:clj
   (defmacro every
     ([schema])
     ([schema sample-limit])))


;;; Main macros
#?(:clj (defmacro >def [k v]))

(defn validate [schema value])
(defn explain [schema value])
(defn -block [text body printer])
(defn -exception-doc [e printer])
(defn reporter ([]) ([printer]))
(defn verbose-humanize-schema [data opts])
(defn humanize-schema [{:keys [schema] :as explain-data} {:guardrails/keys [fqnm compact? args?] :as opts}])

#?(:clj
   (defmacro >defn
     "Like defn, but requires a (nilable) gspec definition and generates
     additional Malli function schema metadata and validation code."
     {:arglists '([name doc-string? attr-map? [params*] gspec prepost-map? body?]
                  [name doc-string? attr-map? ([params*] gspec prepost-map? body?) + attr-map?])}
     [& forms]
     `(defn ~@forms)))

#?(:clj
   (defmacro >defn-
     "Like defn-, but requires a (nilable) gspec definition and generates
     additional Malli function schema metadata and validation code."
     {:arglists '([name doc-string? attr-map? [params*] gspec prepost-map? body?]
                  [name doc-string? attr-map? ([params*] gspec prepost-map? body?) + attr-map?])}
     [& forms]
     `(defn- ~@forms)))

#?(:clj
   (defmacro >fdef
     "Defines a Malli function schema using gspec syntax – pretty much a
     `>defn` without the body. Desugars to `(malli.core/=> ...)."
     {:arglists '([name [params*] gspec]
                  [name ([params*] gspec) +])}
     [& forms]))
