(ns com.fulcrologic.fulcro.dom.html-entities
  "Defs of the proper unicode characters so you can use html entities in your DOM functions without having to
  look them up (or type out silly things like \"\\u00C6\"

  For example:

  ```
  (ns my.ui
    (:require
      [com.fulcrologic.fulcro.dom.html-entities :as ent]))

  ...
     (dom/div ent/nbsp ent/copy)
  ...
  ```
  "
  (:refer-clojure :exclude [and divide empty int not or quot]))

(def AElig "\u00C6")
(def Aacute "\u00C1")
(def Acirc "\u00C2")
(def Agrave "\u00C0")
(def Alpha "\u0391")
(def Aring "\u00C5")
(def Atilde "\u00C3")
(def Auml "\u00C4")
(def Beta "\u0392")
(def Ccedil "\u00C7")
(def Chi "\u03A7")
(def Dagger "\u2021")
(def Delta "\u0394")
(def ETH "\u00D0")
(def Eacute "\u00C9")
(def Ecirc "\u00CA")
(def Egrave "\u00C8")
(def Epsilon "\u0395")
(def Eta "\u0397")
(def Euml "\u00CB")
(def Gamma "\u0393")
(def Iacute "\u00CD")
(def Icirc "\u00CE")
(def Igrave "\u00CC")
(def Iota "\u0399")
(def Iuml "\u00CF")
(def Kappa "\u039A")
(def Lambda "\u039B")
(def Mu "\u039C")
(def Ntilde "\u00D1")
(def Nu "\u039D")
(def OElig "\u0152")
(def Oacute "\u00D3")
(def Ocirc "\u00D4")
(def Ograve "\u00D2")
(def Omega "\u03A9")
(def Omicron "\u039F")
(def Oslash "\u00D8")
(def Otilde "\u00D5")
(def Ouml "\u00D6")
(def Phi "\u03A6")
(def Pi "\u03A0")
(def Prime "\u2033")
(def Psi "\u03A8")
(def Rho "\u03A1")
(def Scaron "\u0160")
(def Sigma "\u03A3")
(def THORN "\u00DE")
(def Tau "\u03A4")
(def Theta "\u0398")
(def Uacute "\u00DA")
(def Ucirc "\u00DB")
(def Ugrave "\u00D9")
(def Upsilon "\u03A5")
(def Uuml "\u00DC")
(def Xi "\u039E")
(def Yacute "\u00DD")
(def Yuml "\u0178")
(def Zeta "\u0396")
(def aacute "\u00E1")
(def acirc "\u00E2")
(def acute "\u00B4")
(def aelig "\u00E6")
(def agrave "\u00E0")
(def alefsym "\u2135")
(def alpha "\u03B1")
(def amp "\u0026")
(def and "\u2227")
(def ang "\u2220")
(def apos "\u0027")
(def aring "\u00E5")
(def asymp "\u2248")
(def atilde "\u00E3")
(def auml "\u00E4")
(def bdquo "\u201E")
(def beta "\u03B2")
(def brvbar "\u00A6")
(def bull "\u2022")
(def cap "\u2229")
(def ccedil "\u00E7")
(def cedil "\u00B8")
(def cent "\u00A2")
(def chi "\u03C7")
(def circ "\u02C6")
(def clubs "\u2663")
(def cong "\u2245")
(def copy "\u00A9")
(def crarr "\u21B5")
(def cup "\u222A")
(def curren "\u00A4")
(def dArr "\u21D3")
(def dagger "\u2020")
(def darr "\u2193")
(def deg "\u00B0")
(def delta "\u03B4")
(def diams "\u2666")
(def divide "\u00F7")
(def eacute "\u00E9")
(def ecirc "\u00EA")
(def egrave "\u00E8")
(def empty "\u2205")
(def emsp "\u2003")
(def ensp "\u2002")
(def epsilon "\u03B5")
(def equiv "\u2261")
(def eta "\u03B7")
(def eth "\u00F0")
(def euml "\u00EB")
(def euro "\u20AC")
(def exist "\u2203")
(def fnof "\u0192")
(def forall "\u2200")
(def frac12 "\u00BD")
(def frac14 "\u00BC")
(def frac34 "\u00BE")
(def frasl "\u2044")
(def gamma "\u03B3")
(def ge "\u2265")
(def gt "\u003E")
(def hArr "\u21D4")
(def harr "\u2194")
(def hearts "\u2665")
(def hellip "\u2026")
(def horbar "\u2015")
(def iacute "\u00ED")
(def icirc "\u00EE")
(def iexcl "\u00A1")
(def igrave "\u00EC")
(def image "\u2111")
(def infin "\u221E")
(def int "\u222B")
(def iota "\u03B9")
(def iquest "\u00BF")
(def isin "\u2208")
(def iuml "\u00EF")
(def kappa "\u03BA")
(def lArr "\u21D0")
(def lambda "\u03BB")
(def lang "\u2329")
(def laqao "\u00AB")                                        ; sic
(def laquo "\u00AB")
(def larr "\u2190")
(def lceil "\u2308")
(def ldquo "\u201C")
(def le "\u2264")
(def lfloor "\u230A")
(def lowast "\u2217")
(def loz "\u25CA")
(def lrm "\u200E")
(def lsaquo "\u2039")
(def lsquo "\u2018")
(def lt "\u003C")
(def macr "\u00AF")
(def mdash "\u2014")
(def micro "\u00B5")
(def middot "\u00B7")
(def minus "\u2212")
(def mu "\u03BC")
(def nabla "\u2207")
(def nbsp "\u00A0")
(def ndash "\u2013")
(def ne "\u2260")
(def ni "\u220B")
(def not "\u00AC")
(def notin "\u2209")
(def nsub "\u2284")
(def ntilde "\u00F1")
(def nu "\u03BD")
(def oacute "\u00F3")
(def ocirc "\u00F4")
(def oelig "\u0153")
(def ograve "\u00F2")
(def oline "\u203E")
(def omega "\u03C9")
(def omicron "\u03BF")
(def oplus "\u2295")
(def or "\u2228")
(def ordf "\u00AA")
(def ordm "\u00BA")
(def oslash "\u00F8")
(def otilde "\u00F5")
(def otimes "\u2297")
(def ouml "\u00F6")
(def para "\u00B6")
(def part "\u2202")
(def permil "\u2030")
(def perp "\u22A5")
(def phi "\u03C6")
(def pi "\u03C0")
(def piv "\u03D6")
(def plusmn "\u00B1")
(def pound "\u00A3")
(def prime "\u2032")
(def prod "\u220F")
(def prop "\u221D")
(def psi "\u03C8")
(def quot "\u0022")
(def rArr "\u21D2")
(def radic "\u221A")
(def rang "\u232A")
(def raqao "\u00BB")                                        ; sic
(def raquo "\u00BB")
(def rarr "\u2192")
(def rceil "\u2309")
(def rdquo "\u201D")
(def real "\u211C")
(def reg "\u00AE")
(def rfloor "\u230B")
(def rho "\u03C1")
(def rlm "\u200F")
(def rsaquo "\u203A")
(def rsquo "\u2019")
(def sbquo "\u201A")
(def scaron "\u0161")
(def sdot "\u22C5")
(def sect "\u00A7")
(def shy "\u00AD")
(def sigma "\u03C3")
(def sigmaf "\u03C2")
(def sim "\u223C")
(def spades "\u2660")
(def sub "\u2282")
(def sube "\u2286")
(def sum "\u2211")
(def sup "\u2283")
(def sup1 "\u00B9")
(def sup2 "\u00B2")
(def sup3 "\u00B3")
(def supe "\u2287")
(def szlig "\u00DF")
(def tau "\u03C4")
(def there4 "\u2234")
(def theta "\u03B8")
(def thetasym "\u03D1")
(def thinsp "\u2009")
(def thorn "\u00FE")
(def tilde "\u02DC")
(def times "\u00D7")
(def trade "\u2122")
(def uArr "\u21D1")
(def uacute "\u00FA")
(def uarr "\u2191")
(def ucirc "\u00FB")
(def ugrave "\u00F9")
(def uml "\u00A8")
(def upsih "\u03D2")
(def upsilon "\u03C5")
(def uuml "\u00FC")
(def weierp "\u2118")
(def xi "\u03BE")
(def yacute "\u00FD")
(def yen "\u00A5")
(def yuml "\u00FF")
(def zeta "\u03B6")
(def zwj "\u200D")
(def zwnj "\u200C")
