(ns com.fulcrologic.rad.database-adapters.datomic-options)

;; Attribute options

(def native-id?
  "If true it will map the given ID attribute (which must be type long) to :db/id."
  :com.fulcrologic.rad.database-adapters.datomic/native-id?)

(def attribute-schema
  "a map of datomic schema attributes to be included in transacted schema.
    example:  {:db/isComponent true}
  "
  :com.fulcrologic.rad.database-adapters.datomic/attribute-schema)

;; Other

(def connections
  "If using the datomic pathom-plugin, the resulting pathm-env will contain
    a map from schema->connection at this key path"
  :com.fulcrologic.rad.database-adapters.datomic/connections)

(def databases
  "If using the datomic pathom-plugin, the resulting pathom-env will contain
    a map from schema->database at this key path"
  :com.fulcrologic.rad.database-adapters.datomic/databases)

(def wrap-resolve
  "Identity Attribute option. A `(fn [resolve])` that must return a `(fn [env input])`. The `resolve` is the core
   resolving logic (a function of env/input), so the returned function can manipulate the resolver inputs and outputs.

   This only affects Datomic autogenerated resolvers."
  :com.fulcrologic.rad.database-adapters.datomic/wrap-resolve)

(def raw-txn
  "Middleware environment key. A sequence of Datomic transaction data in the list and/or map form, which will be added to the
   transaction data produced by the currently active (save or delete) middleware.

   You can use this in save middleware, delete middleware, or even pathom middleware (since the save/delete env starts as
   pathom env).

   You can use this to ensure pre- and post-condition, enrich the transactions, etc.
   See also `datomic-common/append-to-raw-txn`.

   Ex.:
   ```clj
   (let [user ..., order ..., ident ...]
    (cond-> middleware-env
      (first-order-campaign? order)
      (datomic-common/append-to-raw-txn
        [(list 'my.txn.fns/ensure-no-prior-order user) ; check pre-condition
         {:db/id \"datomic.tx\" :tx/user (:email user)} ; enrich transaction info
         {:db/id (datomic-common/failsafe-id env ident) :db/ensure :order/valid-new-order}]))) ; check post-condition
   ```"
  :com.fulcrologic.rad.database-adapters.datomic/raw-txn)

(def generate-minimal-pull?
  "ID Attribute option for resolver generation.  Default false.

   Indicates that the Datomic pull that should run in a resolver should be minimal.

   By default the resolvers cache their results in a request, so a minimal query can cause requests
   for different elements of the same entity to fail (because only the first cached version will be
   used).

   So, if you specify this it will automatically force `resolver-cache? false` for the generated resolver
   (unless overridden)."
  :com.fulcrologic.rad.database-adapters.datomic/generate-minimal-pull?)

(def resolver-cache?
  "ID Attribute option for resolver generation.

   Indicates that the per-request response cache NOT cache instances
   of this particular entity. This is necessary if you might have recursive queries for the same entity, and you
   have asked the resolvers to generate a minimal pull.

   Defaults to `true` in Pathom, but will be forced to false if minimal pulls are used (which you can override
   with this option)."
  :com.fulcrologic.rad.database-adapters.datomic/resolver-cache?)
