/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.unpacker;

import com.fulcrologicpro.org.msgpack.MessagePack;
import com.fulcrologicpro.org.msgpack.packer.Unconverter;
import com.fulcrologicpro.org.msgpack.template.Template;
import com.fulcrologicpro.org.msgpack.type.Value;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import com.fulcrologicpro.org.msgpack.unpacker.UnpackerIterator;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractUnpacker
implements Unpacker {
    protected MessagePack msgpack;
    protected int rawSizeLimit = 0x8000000;
    protected int arraySizeLimit = 0x400000;
    protected int mapSizeLimit = 0x200000;

    protected AbstractUnpacker(MessagePack msgpack) {
        this.msgpack = msgpack;
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }

    @Override
    public void readArrayEnd() throws IOException {
        this.readArrayEnd(false);
    }

    @Override
    public void readMapEnd() throws IOException {
        this.readMapEnd(false);
    }

    @Override
    public UnpackerIterator iterator() {
        return new UnpackerIterator(this);
    }

    protected abstract void readValue(Unconverter var1) throws IOException;

    @Override
    public Value readValue() throws IOException {
        Unconverter uc = new Unconverter(this.msgpack);
        this.readValue(uc);
        return uc.getResult();
    }

    protected abstract boolean tryReadNil() throws IOException;

    @Override
    public <T> T read(Class<T> klass) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        Template<Object> tmpl = this.msgpack.lookup(klass);
        return tmpl.read(this, null);
    }

    @Override
    public <T> T read(T to) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        Template<?> tmpl = this.msgpack.lookup(to.getClass());
        return (T)tmpl.read(this, to);
    }

    @Override
    public <T> T read(Template<T> tmpl) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        return tmpl.read(this, null);
    }

    @Override
    public <T> T read(T to, Template<T> tmpl) throws IOException {
        if (this.tryReadNil()) {
            return null;
        }
        return tmpl.read(this, to);
    }

    @Override
    public int getReadByteCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void resetReadByteCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setRawSizeLimit(int size) {
        this.rawSizeLimit = size < 32 ? 32 : size;
    }

    @Override
    public void setArraySizeLimit(int size) {
        this.arraySizeLimit = size < 16 ? 16 : size;
    }

    @Override
    public void setMapSizeLimit(int size) {
        this.mapSizeLimit = size < 16 ? 16 : size;
    }
}

