/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.type;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.type.IntegerValue;
import com.fulcrologicpro.org.msgpack.type.Value;
import java.io.IOException;
import java.math.BigInteger;

class BigIntegerValueImpl
extends IntegerValue {
    private BigInteger value;
    private static BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    private static BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    private static BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    private static BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    private static BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    BigIntegerValueImpl(BigInteger value) {
        this.value = value;
    }

    @Override
    public byte getByte() {
        if (this.value.compareTo(BYTE_MAX) > 0 || this.value.compareTo(BYTE_MIN) < 0) {
            throw new MessageTypeException();
        }
        return this.value.byteValue();
    }

    @Override
    public short getShort() {
        if (this.value.compareTo(SHORT_MAX) > 0 || this.value.compareTo(SHORT_MIN) < 0) {
            throw new MessageTypeException();
        }
        return this.value.shortValue();
    }

    @Override
    public int getInt() {
        if (this.value.compareTo(INT_MAX) > 0 || this.value.compareTo(INT_MIN) < 0) {
            throw new MessageTypeException();
        }
        return this.value.intValue();
    }

    @Override
    public long getLong() {
        if (this.value.compareTo(LONG_MAX) > 0 || this.value.compareTo(LONG_MIN) < 0) {
            throw new MessageTypeException();
        }
        return this.value.longValue();
    }

    @Override
    public BigInteger getBigInteger() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.write(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isIntegerValue()) {
            return false;
        }
        return this.value.equals(v.asIntegerValue().bigIntegerValue());
    }

    public int hashCode() {
        if (INT_MIN.compareTo(this.value) <= 0 && this.value.compareTo(INT_MAX) <= 0) {
            return (int)this.value.longValue();
        }
        if (LONG_MIN.compareTo(this.value) <= 0 && this.value.compareTo(LONG_MAX) <= 0) {
            long v = this.value.longValue();
            return (int)(v ^ v >>> 32);
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return sb.append(this.value.toString());
    }
}

