/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class FloatTemplate
extends AbstractTemplate<Float> {
    static final FloatTemplate instance = new FloatTemplate();

    private FloatTemplate() {
    }

    @Override
    public void write(Packer pk, Float target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target.floatValue());
    }

    @Override
    public Float read(Unpacker u, Float to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return Float.valueOf(u.readFloat());
    }

    public static FloatTemplate getInstance() {
        return instance;
    }
}

