/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class DoubleTemplate
extends AbstractTemplate<Double> {
    static final DoubleTemplate instance = new DoubleTemplate();

    private DoubleTemplate() {
    }

    @Override
    public void write(Packer pk, Double target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write((double)target);
    }

    @Override
    public Double read(Unpacker u, Double to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readDouble();
    }

    public static DoubleTemplate getInstance() {
        return instance;
    }
}

