/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.template.Template;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class CollectionTemplate<E>
extends AbstractTemplate<Collection<E>> {
    private Template<E> elementTemplate;

    public CollectionTemplate(Template<E> elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    @Override
    public void write(Packer pk, Collection<E> target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        Collection<E> col = target;
        pk.writeArrayBegin(col.size());
        for (E e : col) {
            this.elementTemplate.write(pk, e);
        }
        pk.writeArrayEnd();
    }

    @Override
    public Collection<E> read(Unpacker u, Collection<E> to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null) {
            to = new LinkedList();
        } else {
            to.clear();
        }
        for (int i = 0; i < n; ++i) {
            Object e = this.elementTemplate.read(u, null);
            to.add(e);
        }
        u.readArrayEnd();
        return to;
    }
}

