/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class ByteArrayTemplate
extends AbstractTemplate<byte[]> {
    static final ByteArrayTemplate instance = new ByteArrayTemplate();

    private ByteArrayTemplate() {
    }

    @Override
    public void write(Packer pk, byte[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target);
    }

    @Override
    public byte[] read(Unpacker u, byte[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readByteArray();
    }

    public static ByteArrayTemplate getInstance() {
        return instance;
    }
}

