/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.util.json;

import com.fulcrologicpro.org.msgpack.MessagePack;
import com.fulcrologicpro.org.msgpack.unpacker.BufferUnpacker;
import com.fulcrologicpro.org.msgpack.util.json.JSONUnpacker;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;

public class JSONBufferUnpacker
extends JSONUnpacker
implements BufferUnpacker {
    private static final int DEFAULT_BUFFER_SIZE = 512;

    public JSONBufferUnpacker() {
        this(512);
    }

    public JSONBufferUnpacker(int bufferSize) {
        this(new MessagePack(), bufferSize);
    }

    public JSONBufferUnpacker(MessagePack msgpack) {
        this(msgpack, 512);
    }

    public JSONBufferUnpacker(MessagePack msgpack, int bufferSize) {
        super(msgpack, JSONBufferUnpacker.newEmptyReader());
    }

    @Override
    public JSONBufferUnpacker wrap(byte[] b) {
        return this.wrap(b, 0, b.length);
    }

    @Override
    public JSONBufferUnpacker wrap(byte[] b, int off, int len) {
        ByteArrayInputStream in = new ByteArrayInputStream(b, off, len);
        this.in = new InputStreamReader(in);
        return this;
    }

    @Override
    public JSONBufferUnpacker wrap(ByteBuffer buf) {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support wrap(ByteBuffer buf)");
    }

    @Override
    public JSONBufferUnpacker feed(byte[] b) {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support feed()");
    }

    @Override
    public JSONBufferUnpacker feed(byte[] b, boolean reference) {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support feed()");
    }

    @Override
    public JSONBufferUnpacker feed(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support feed()");
    }

    @Override
    public JSONBufferUnpacker feed(byte[] b, int off, int len, boolean reference) {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support feed()");
    }

    @Override
    public JSONBufferUnpacker feed(ByteBuffer buf) {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support feed()");
    }

    @Override
    public JSONBufferUnpacker feed(ByteBuffer buf, boolean reference) {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support feed()");
    }

    @Override
    public int getBufferSize() {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support getBufferSize()");
    }

    @Override
    public void copyReferencedBuffer() {
        throw new UnsupportedOperationException("JSONBufferUnpacker doesn't support copyReferencedBuffer()");
    }

    @Override
    public void clear() {
        this.reset();
        this.in = JSONBufferUnpacker.newEmptyReader();
    }

    private static Reader newEmptyReader() {
        return new InputStreamReader(new ByteArrayInputStream(new byte[0]));
    }
}

