/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.template.Template;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ListTemplate<E>
extends AbstractTemplate<List<E>> {
    private Template<E> elementTemplate;

    public ListTemplate(Template<E> elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    @Override
    public void write(Packer pk, List<E> target, boolean required) throws IOException {
        if (!(target instanceof List)) {
            if (target == null) {
                if (required) {
                    throw new MessageTypeException("Attempted to write null");
                }
                pk.writeNil();
                return;
            }
            throw new MessageTypeException("Target is not a List but " + target.getClass());
        }
        pk.writeArrayBegin(target.size());
        for (E e : target) {
            this.elementTemplate.write(pk, e);
        }
        pk.writeArrayEnd();
    }

    @Override
    public List<E> read(Unpacker u, List<E> to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null) {
            to = new ArrayList(n);
        } else {
            to.clear();
        }
        for (int i = 0; i < n; ++i) {
            Object e = this.elementTemplate.read(u, null);
            to.add(e);
        }
        u.readArrayEnd();
        return to;
    }
}

