/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;
import java.math.BigDecimal;

public class BigDecimalTemplate
extends AbstractTemplate<BigDecimal> {
    static final BigDecimalTemplate instance = new BigDecimalTemplate();

    private BigDecimalTemplate() {
    }

    @Override
    public void write(Packer pk, BigDecimal target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target.toString());
    }

    @Override
    public BigDecimal read(Unpacker u, BigDecimal to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        String temp = u.readString();
        return new BigDecimal(temp);
    }

    public static BigDecimalTemplate getInstance() {
        return instance;
    }
}

