/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template.builder.beans;

import com.fulcrologicpro.org.msgpack.template.builder.beans.FeatureDescriptor;

public class BeanDescriptor
extends FeatureDescriptor {
    private Class<?> beanClass;
    private Class<?> customizerClass;

    public BeanDescriptor(Class<?> beanClass, Class<?> customizerClass) {
        if (beanClass == null) {
            throw new NullPointerException();
        }
        this.setName(this.getShortClassName(beanClass));
        this.beanClass = beanClass;
        this.customizerClass = customizerClass;
    }

    public BeanDescriptor(Class<?> beanClass) {
        this(beanClass, null);
    }

    public Class<?> getCustomizerClass() {
        return this.customizerClass;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    private String getShortClassName(Class<?> leguminaClass) {
        if (leguminaClass == null) {
            return null;
        }
        String beanClassName = leguminaClass.getName();
        int lastIndex = beanClassName.lastIndexOf(".");
        return lastIndex == -1 ? beanClassName : beanClassName.substring(lastIndex + 1);
    }
}

