/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.template.TemplateRegistry;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class AnyTemplate<T>
extends AbstractTemplate<T> {
    private TemplateRegistry registry;

    public AnyTemplate(TemplateRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void write(Packer pk, T target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
        } else {
            this.registry.lookup(target.getClass()).write(pk, target);
        }
    }

    @Override
    public T read(Unpacker u, T to, boolean required) throws IOException, MessageTypeException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        if (to == null) {
            throw new MessageTypeException("convert into unknown type is invalid");
        }
        T o = u.read(to);
        if (required && o == null) {
            throw new MessageTypeException("Unexpected nil value");
        }
        return o;
    }
}

