/*
 * Copyright (c) 2010-2020 Nathan Rajlich
 *
 *  Permission is hereby granted, free of charge, to any person
 *  obtaining a copy of this software and associated documentation
 *  files (the "Software"), to deal in the Software without
 *  restriction, including without limitation the rights to use,
 *  copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following
 *  conditions:
 *
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *  OTHER DEALINGS IN THE SOFTWARE.
 */

package com.fulcrologic_pro.org.java_websocket.extensions;

import com.fulcrologic_pro.org.java_websocket.exceptions.InvalidDataException;
import com.fulcrologic_pro.org.java_websocket.exceptions.InvalidFrameException;
import com.fulcrologic_pro.org.java_websocket.framing.ControlFrame;
import com.fulcrologic_pro.org.java_websocket.framing.DataFrame;
import com.fulcrologic_pro.org.java_websocket.framing.Framedata;

/**
 * Implementation for a compression extension specified by https://tools.ietf.org/html/rfc7692
 * @since 1.3.5
 */
public abstract class CompressionExtension extends DefaultExtension {

	@Override
	public void isFrameValid( Framedata inputFrame ) throws InvalidDataException {
		if(( inputFrame instanceof DataFrame ) && ( inputFrame.isRSV2() || inputFrame.isRSV3() )) {
			throw new InvalidFrameException( "bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3() );
		}
		if(( inputFrame instanceof ControlFrame ) && ( inputFrame.isRSV1() || inputFrame.isRSV2() || inputFrame.isRSV3() )) {
			throw new InvalidFrameException( "bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3() );
		}
	}
}
