/*
 * Decompiled with CFR 0.152.
 */
package com.iwebpp.crypto;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

public final class TweetNacl {
    private static final String TAG = "TweetNacl";
    private static final byte[] _0;
    private static final byte[] _9;
    private static final long[] gf0;
    private static final long[] gf1;
    private static final long[] _121665;
    private static final long[] D;
    private static final long[] D2;
    private static final long[] X;
    private static final long[] Y;
    private static final long[] I;
    private static final byte[] sigma;
    private static final long[] K;
    private static final byte[] iv;
    private static final long[] L;
    private static final SecureRandom jrandom;

    private static int L32(int n, int n2) {
        return n << n2 | (n & 0xFFFFFFFF) >>> 32 - n2;
    }

    private static int ld32(byte[] byArray, int n, int n2) {
        int n3 = byArray[3 + n] & 0xFF;
        n3 = n3 << 8 | byArray[2 + n] & 0xFF;
        n3 = n3 << 8 | byArray[1 + n] & 0xFF;
        return n3 << 8 | byArray[0 + n] & 0xFF;
    }

    private static long dl64(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(byArray[i + n] & 0xFF);
        }
        return l;
    }

    private static void st32(byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < 4; ++i) {
            byArray[i + n] = (byte)(n3 & 0xFF);
            n3 >>>= 8;
        }
    }

    private static void ts64(byte[] byArray, int n, int n2, long l) {
        for (int i = 7; i >= 0; --i) {
            byArray[i + n] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
    }

    private static int vn(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) {
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            n6 |= (byArray[i + n] ^ byArray2[i + n3]) & 0xFF;
        }
        return (1 & n6 - 1 >>> 8) - 1;
    }

    private static int crypto_verify_16(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return TweetNacl.vn(byArray, n, n2, byArray2, n3, n4, 16);
    }

    public static int crypto_verify_16(byte[] byArray, byte[] byArray2) {
        return TweetNacl.crypto_verify_16(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    private static int crypto_verify_32(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return TweetNacl.vn(byArray, n, n2, byArray2, n3, n4, 32);
    }

    public static int crypto_verify_32(byte[] byArray, byte[] byArray2) {
        return TweetNacl.crypto_verify_32(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    private static void core(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        int n2;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[4];
        for (n2 = 0; n2 < 4; ++n2) {
            nArray2[5 * n2] = TweetNacl.ld32(byArray4, 4 * n2, 4);
            nArray2[1 + n2] = TweetNacl.ld32(byArray3, 4 * n2, 4);
            nArray2[6 + n2] = TweetNacl.ld32(byArray2, 4 * n2, 4);
            nArray2[11 + n2] = TweetNacl.ld32(byArray3, 16 + 4 * n2, 4);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            nArray3[n2] = nArray2[n2];
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n3;
            for (int i = 0; i < 4; ++i) {
                for (n3 = 0; n3 < 4; ++n3) {
                    nArray4[n3] = nArray2[(5 * i + 4 * n3) % 16];
                }
                nArray4[1] = nArray4[1] ^ TweetNacl.L32(nArray4[0] + nArray4[3], 7);
                nArray4[2] = nArray4[2] ^ TweetNacl.L32(nArray4[1] + nArray4[0], 9);
                nArray4[3] = nArray4[3] ^ TweetNacl.L32(nArray4[2] + nArray4[1], 13);
                nArray4[0] = nArray4[0] ^ TweetNacl.L32(nArray4[3] + nArray4[2], 18);
                for (n3 = 0; n3 < 4; ++n3) {
                    nArray[4 * i + (i + n3) % 4] = nArray4[n3];
                }
            }
            for (n3 = 0; n3 < 16; ++n3) {
                nArray2[n3] = nArray[n3];
            }
        }
        if (n != 0) {
            for (n2 = 0; n2 < 16; ++n2) {
                int n4 = n2;
                nArray2[n4] = nArray2[n4] + nArray3[n2];
            }
            for (n2 = 0; n2 < 4; ++n2) {
                int n5 = 5 * n2;
                nArray2[n5] = nArray2[n5] - TweetNacl.ld32(byArray4, 4 * n2, 4);
                int n6 = 6 + n2;
                nArray2[n6] = nArray2[n6] - TweetNacl.ld32(byArray2, 4 * n2, 4);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                TweetNacl.st32(byArray, 4 * n2, 4, nArray2[5 * n2]);
                TweetNacl.st32(byArray, 16 + 4 * n2, 4, nArray2[6 + n2]);
            }
        } else {
            for (n2 = 0; n2 < 16; ++n2) {
                TweetNacl.st32(byArray, 4 * n2, 4, nArray2[n2] + nArray3[n2]);
            }
        }
    }

    public static int crypto_core_salsa20(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        TweetNacl.core(byArray, byArray2, byArray3, byArray4, 0);
        return 0;
    }

    public static int crypto_core_hsalsa20(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        TweetNacl.core(byArray, byArray2, byArray3, byArray4, 1);
        return 0;
    }

    private static int crypto_stream_salsa20_xor(byte[] byArray, byte[] byArray2, long l, byte[] byArray3, int n, int n2, byte[] byArray4) {
        int n3;
        byte[] byArray5 = new byte[16];
        byte[] byArray6 = new byte[64];
        if (0L == l) {
            return 0;
        }
        for (n3 = 0; n3 < 16; ++n3) {
            byArray5[n3] = 0;
        }
        for (n3 = 0; n3 < 8; ++n3) {
            byArray5[n3] = byArray3[n3 + n];
        }
        int n4 = 0;
        int n5 = 0;
        while (l >= 64L) {
            TweetNacl.crypto_core_salsa20(byArray6, byArray5, byArray4, sigma);
            for (n3 = 0; n3 < 64; ++n3) {
                byArray[n3 + n4] = (byte)(((byArray2 != null ? byArray2[n3 + n5] : (byte)0) ^ byArray6[n3]) & 0xFF);
            }
            int n6 = 1;
            for (n3 = 8; n3 < 16; ++n3) {
                byArray5[n3] = (byte)((n6 += byArray5[n3] & 0xFF) & 0xFF);
                n6 >>>= 8;
            }
            l -= 64L;
            n4 += 64;
            if (byArray2 == null) continue;
            n5 += 64;
        }
        if (l != 0L) {
            TweetNacl.crypto_core_salsa20(byArray6, byArray5, byArray4, sigma);
            n3 = 0;
            while ((long)n3 < l) {
                byArray[n3 + n4] = (byte)(((byArray2 != null ? byArray2[n3 + n5] : (byte)0) ^ byArray6[n3]) & 0xFF);
                ++n3;
            }
        }
        return 0;
    }

    public static int crypto_stream_salsa20_xor(byte[] byArray, byte[] byArray2, long l, byte[] byArray3, byte[] byArray4) {
        return TweetNacl.crypto_stream_salsa20_xor(byArray, byArray2, l, byArray3, 0, byArray3.length, byArray4);
    }

    private static int crypto_stream_salsa20(byte[] byArray, long l, byte[] byArray2, int n, int n2, byte[] byArray3) {
        return TweetNacl.crypto_stream_salsa20_xor(byArray, null, l, byArray2, n, n2, byArray3);
    }

    public static int crypto_stream_salsa20(byte[] byArray, long l, byte[] byArray2, byte[] byArray3) {
        return TweetNacl.crypto_stream_salsa20(byArray, l, byArray2, 0, byArray2.length, byArray3);
    }

    public static int crypto_stream(byte[] byArray, long l, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[32];
        TweetNacl.crypto_core_hsalsa20(byArray4, byArray2, byArray3, sigma);
        return TweetNacl.crypto_stream_salsa20(byArray, l, byArray2, 16, byArray2.length - 16, byArray4);
    }

    public static int crypto_stream_xor(byte[] byArray, byte[] byArray2, long l, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[32];
        TweetNacl.crypto_core_hsalsa20(byArray5, byArray3, byArray4, sigma);
        return TweetNacl.crypto_stream_salsa20_xor(byArray, byArray2, l, byArray3, 16, byArray3.length - 16, byArray5);
    }

    private static int crypto_onetimeauth(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, byte[] byArray3) {
        poly1305 poly13052 = new poly1305(byArray3);
        poly13052.update(byArray2, n3, n5);
        poly13052.finish(byArray, n);
        return 0;
    }

    public static int crypto_onetimeauth(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        return TweetNacl.crypto_onetimeauth(byArray, 0, byArray.length, byArray2, 0, byArray2.length, n, byArray3);
    }

    private static int crypto_onetimeauth_verify(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, byte[] byArray3) {
        byte[] byArray4 = new byte[16];
        TweetNacl.crypto_onetimeauth(byArray4, 0, byArray4.length, byArray2, n3, n4, n5, byArray3);
        return TweetNacl.crypto_verify_16(byArray, n, n2, byArray4, 0, byArray4.length);
    }

    public static int crypto_onetimeauth_verify(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        return TweetNacl.crypto_onetimeauth_verify(byArray, 0, byArray.length, byArray2, 0, byArray2.length, n, byArray3);
    }

    public static int crypto_onetimeauth_verify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return TweetNacl.crypto_onetimeauth_verify(byArray, byArray2, byArray2 != null ? byArray2.length : 0, byArray3);
    }

    public static int crypto_secretbox(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        if (n < 32) {
            return -1;
        }
        TweetNacl.crypto_stream_xor(byArray, byArray2, n, byArray3, byArray4);
        TweetNacl.crypto_onetimeauth(byArray, 16, byArray.length - 16, byArray, 32, byArray.length - 32, n - 32, byArray);
        return 0;
    }

    public static int crypto_secretbox_open(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[32];
        if (n < 32) {
            return -1;
        }
        TweetNacl.crypto_stream(byArray5, 32L, byArray3, byArray4);
        if (TweetNacl.crypto_onetimeauth_verify(byArray2, 16, 16, byArray2, 32, byArray2.length - 32, n - 32, byArray5) != 0) {
            return -1;
        }
        TweetNacl.crypto_stream_xor(byArray, byArray2, n, byArray3, byArray4);
        return 0;
    }

    private static void set25519(long[] lArray, long[] lArray2) {
        for (int i = 0; i < 16; ++i) {
            lArray[i] = lArray2[i];
        }
    }

    private static void car25519(long[] lArray, int n, int n2) {
        for (int i = 0; i < 16; ++i) {
            int n3 = i + n;
            lArray[n3] = lArray[n3] + 65536L;
            long l = lArray[i + n] >> 16;
            int n4 = (i + 1) * (i < 15 ? 1 : 0) + n;
            lArray[n4] = lArray[n4] + (l - 1L + 37L * (l - 1L) * (long)(i == 15 ? 1 : 0));
            int n5 = i + n;
            lArray[n5] = lArray[n5] - (l << 16);
        }
    }

    private static void sel25519(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, int n5) {
        long l = ~(n5 - 1);
        for (int i = 0; i < 16; ++i) {
            long l2 = l & (lArray[i + n] ^ lArray2[i + n3]);
            int n6 = i + n;
            lArray[n6] = lArray[n6] ^ l2;
            int n7 = i + n3;
            lArray2[n7] = lArray2[n7] ^ l2;
        }
    }

    private static void pack25519(byte[] byArray, long[] lArray, int n, int n2) {
        int n3;
        long[] lArray2 = new long[16];
        long[] lArray3 = new long[16];
        for (n3 = 0; n3 < 16; ++n3) {
            lArray3[n3] = lArray[n3 + n];
        }
        TweetNacl.car25519(lArray3, 0, lArray3.length);
        TweetNacl.car25519(lArray3, 0, lArray3.length);
        TweetNacl.car25519(lArray3, 0, lArray3.length);
        for (int i = 0; i < 2; ++i) {
            lArray2[0] = lArray3[0] - 65517L;
            for (n3 = 1; n3 < 15; ++n3) {
                lArray2[n3] = lArray3[n3] - 65535L - (lArray2[n3 - 1] >> 16 & 1L);
                int n4 = n3 - 1;
                lArray2[n4] = lArray2[n4] & 0xFFFFL;
            }
            lArray2[15] = lArray3[15] - 32767L - (lArray2[14] >> 16 & 1L);
            int n5 = (int)(lArray2[15] >> 16 & 1L);
            lArray2[14] = lArray2[14] & 0xFFFFL;
            TweetNacl.sel25519(lArray3, 0, lArray3.length, lArray2, 0, lArray2.length, 1 - n5);
        }
        for (n3 = 0; n3 < 16; ++n3) {
            byArray[2 * n3] = (byte)(lArray3[n3] & 0xFFL);
            byArray[2 * n3 + 1] = (byte)(lArray3[n3] >> 8);
        }
    }

    private static int neq25519(long[] lArray, long[] lArray2) {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        TweetNacl.pack25519(byArray, lArray, 0, lArray.length);
        TweetNacl.pack25519(byArray2, lArray2, 0, lArray2.length);
        return TweetNacl.crypto_verify_32(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    private static byte par25519(long[] lArray) {
        byte[] byArray = new byte[32];
        TweetNacl.pack25519(byArray, lArray, 0, lArray.length);
        return (byte)(byArray[0] & 1);
    }

    private static void unpack25519(long[] lArray, byte[] byArray) {
        for (int i = 0; i < 16; ++i) {
            lArray[i] = (long)(byArray[2 * i] & 0xFF) + (long)(byArray[2 * i + 1] << 8 & 0xFFFF);
        }
        lArray[15] = lArray[15] & 0x7FFFL;
    }

    private static void A(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, long[] lArray3, int n5, int n6) {
        for (int i = 0; i < 16; ++i) {
            lArray[i + n] = lArray2[i + n3] + lArray3[i + n5];
        }
    }

    private static void Z(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, long[] lArray3, int n5, int n6) {
        for (int i = 0; i < 16; ++i) {
            lArray[i + n] = lArray2[i + n3] - lArray3[i + n5];
        }
    }

    private static void M(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, long[] lArray3, int n5, int n6) {
        int n7;
        long[] lArray4 = new long[31];
        for (n7 = 0; n7 < 31; ++n7) {
            lArray4[n7] = 0L;
        }
        for (n7 = 0; n7 < 16; ++n7) {
            for (int i = 0; i < 16; ++i) {
                int n8 = n7 + i;
                lArray4[n8] = lArray4[n8] + lArray2[n7 + n3] * lArray3[i + n5];
            }
        }
        for (n7 = 0; n7 < 15; ++n7) {
            int n9 = n7;
            lArray4[n9] = lArray4[n9] + 38L * lArray4[n7 + 16];
        }
        for (n7 = 0; n7 < 16; ++n7) {
            lArray[n7 + n] = lArray4[n7];
        }
        TweetNacl.car25519(lArray, n, n2);
        TweetNacl.car25519(lArray, n, n2);
    }

    private static void S(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        TweetNacl.M(lArray, n, n2, lArray2, n3, n4, lArray2, n3, n4);
    }

    private static void inv25519(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        int n5;
        long[] lArray3 = new long[16];
        for (n5 = 0; n5 < 16; ++n5) {
            lArray3[n5] = lArray2[n5 + n3];
        }
        for (n5 = 253; n5 >= 0; --n5) {
            TweetNacl.S(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length);
            if (n5 == 2 || n5 == 4) continue;
            TweetNacl.M(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length, lArray2, n3, n4);
        }
        for (n5 = 0; n5 < 16; ++n5) {
            lArray[n5 + n] = lArray3[n5];
        }
    }

    private static void pow2523(long[] lArray, long[] lArray2) {
        int n;
        long[] lArray3 = new long[16];
        for (n = 0; n < 16; ++n) {
            lArray3[n] = lArray2[n];
        }
        for (n = 250; n >= 0; --n) {
            TweetNacl.S(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length);
            if (n == 1) continue;
            TweetNacl.M(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length, lArray2, 0, lArray2.length);
        }
        for (n = 0; n < 16; ++n) {
            lArray[n] = lArray3[n];
        }
    }

    public static int crypto_scalarmult(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[32];
        long[] lArray = new long[80];
        long[] lArray2 = new long[16];
        long[] lArray3 = new long[16];
        long[] lArray4 = new long[16];
        long[] lArray5 = new long[16];
        long[] lArray6 = new long[16];
        long[] lArray7 = new long[16];
        for (n = 0; n < 31; ++n) {
            byArray4[n] = byArray2[n];
        }
        byArray4[31] = (byte)((byArray2[31] & 0x7F | 0x40) & 0xFF);
        byArray4[0] = (byte)(byArray4[0] & 0xF8);
        TweetNacl.unpack25519(lArray, byArray3);
        for (n = 0; n < 16; ++n) {
            lArray3[n] = lArray[n];
            lArray4[n] = 0L;
            lArray2[n] = 0L;
            lArray5[n] = 0L;
        }
        lArray5[0] = 1L;
        lArray2[0] = 1L;
        for (n = 254; n >= 0; --n) {
            int n2 = byArray4[n >>> 3] >>> (n & 7) & 1;
            TweetNacl.sel25519(lArray2, 0, lArray2.length, lArray3, 0, lArray3.length, n2);
            TweetNacl.sel25519(lArray4, 0, lArray4.length, lArray5, 0, lArray5.length, n2);
            TweetNacl.A(lArray6, 0, lArray6.length, lArray2, 0, lArray2.length, lArray4, 0, lArray4.length);
            TweetNacl.Z(lArray2, 0, lArray2.length, lArray2, 0, lArray2.length, lArray4, 0, lArray4.length);
            TweetNacl.A(lArray4, 0, lArray4.length, lArray3, 0, lArray3.length, lArray5, 0, lArray5.length);
            TweetNacl.Z(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length, lArray5, 0, lArray5.length);
            TweetNacl.S(lArray5, 0, lArray5.length, lArray6, 0, lArray6.length);
            TweetNacl.S(lArray7, 0, lArray7.length, lArray2, 0, lArray2.length);
            TweetNacl.M(lArray2, 0, lArray2.length, lArray4, 0, lArray4.length, lArray2, 0, lArray2.length);
            TweetNacl.M(lArray4, 0, lArray4.length, lArray3, 0, lArray3.length, lArray6, 0, lArray6.length);
            TweetNacl.A(lArray6, 0, lArray6.length, lArray2, 0, lArray2.length, lArray4, 0, lArray4.length);
            TweetNacl.Z(lArray2, 0, lArray2.length, lArray2, 0, lArray2.length, lArray4, 0, lArray4.length);
            TweetNacl.S(lArray3, 0, lArray3.length, lArray2, 0, lArray2.length);
            TweetNacl.Z(lArray4, 0, lArray4.length, lArray5, 0, lArray5.length, lArray7, 0, lArray7.length);
            TweetNacl.M(lArray2, 0, lArray2.length, lArray4, 0, lArray4.length, _121665, 0, _121665.length);
            TweetNacl.A(lArray2, 0, lArray2.length, lArray2, 0, lArray2.length, lArray5, 0, lArray5.length);
            TweetNacl.M(lArray4, 0, lArray4.length, lArray4, 0, lArray4.length, lArray2, 0, lArray2.length);
            TweetNacl.M(lArray2, 0, lArray2.length, lArray5, 0, lArray5.length, lArray7, 0, lArray7.length);
            TweetNacl.M(lArray5, 0, lArray5.length, lArray3, 0, lArray3.length, lArray, 0, lArray.length);
            TweetNacl.S(lArray3, 0, lArray3.length, lArray6, 0, lArray6.length);
            TweetNacl.sel25519(lArray2, 0, lArray2.length, lArray3, 0, lArray3.length, n2);
            TweetNacl.sel25519(lArray4, 0, lArray4.length, lArray5, 0, lArray5.length, n2);
        }
        for (n = 0; n < 16; ++n) {
            lArray[n + 16] = lArray2[n];
            lArray[n + 32] = lArray4[n];
            lArray[n + 48] = lArray3[n];
            lArray[n + 64] = lArray5[n];
        }
        TweetNacl.inv25519(lArray, 32, lArray.length - 32, lArray, 32, lArray.length - 32);
        TweetNacl.M(lArray, 16, lArray.length - 16, lArray, 16, lArray.length - 16, lArray, 32, lArray.length - 32);
        TweetNacl.pack25519(byArray, lArray, 16, lArray.length - 16);
        return 0;
    }

    public static int crypto_scalarmult_base(byte[] byArray, byte[] byArray2) {
        return TweetNacl.crypto_scalarmult(byArray, byArray2, _9);
    }

    public static int crypto_box_keypair(byte[] byArray, byte[] byArray2) {
        TweetNacl.randombytes(byArray2, 32);
        return TweetNacl.crypto_scalarmult_base(byArray, byArray2);
    }

    public static int crypto_box_beforenm(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[32];
        TweetNacl.crypto_scalarmult(byArray4, byArray3, byArray2);
        return TweetNacl.crypto_core_hsalsa20(byArray, _0, byArray4, sigma);
    }

    public static int crypto_box_afternm(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        return TweetNacl.crypto_secretbox(byArray, byArray2, n, byArray3, byArray4);
    }

    public static int crypto_box_open_afternm(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        return TweetNacl.crypto_secretbox_open(byArray, byArray2, n, byArray3, byArray4);
    }

    public static int crypto_box(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        byte[] byArray6 = new byte[32];
        TweetNacl.crypto_box_beforenm(byArray6, byArray4, byArray5);
        return TweetNacl.crypto_box_afternm(byArray, byArray2, n, byArray3, byArray6);
    }

    public static int crypto_box_open(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        byte[] byArray6 = new byte[32];
        TweetNacl.crypto_box_beforenm(byArray6, byArray4, byArray5);
        return TweetNacl.crypto_box_open_afternm(byArray, byArray2, n, byArray3, byArray6);
    }

    private static long R(long l, int n) {
        return l >>> n | l << 64 - n;
    }

    private static long Ch(long l, long l2, long l3) {
        return l & l2 ^ (l ^ 0xFFFFFFFFFFFFFFFFL) & l3;
    }

    private static long Maj(long l, long l2, long l3) {
        return l & l2 ^ l & l3 ^ l2 & l3;
    }

    private static long Sigma0(long l) {
        return TweetNacl.R(l, 28) ^ TweetNacl.R(l, 34) ^ TweetNacl.R(l, 39);
    }

    private static long Sigma1(long l) {
        return TweetNacl.R(l, 14) ^ TweetNacl.R(l, 18) ^ TweetNacl.R(l, 41);
    }

    private static long sigma0(long l) {
        return TweetNacl.R(l, 1) ^ TweetNacl.R(l, 8) ^ l >>> 7;
    }

    private static long sigma1(long l) {
        return TweetNacl.R(l, 19) ^ TweetNacl.R(l, 61) ^ l >>> 6;
    }

    private static int crypto_hashblocks(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4;
        long[] lArray = new long[8];
        long[] lArray2 = new long[8];
        long[] lArray3 = new long[8];
        long[] lArray4 = new long[16];
        for (n4 = 0; n4 < 8; ++n4) {
            lArray[n4] = lArray3[n4] = TweetNacl.dl64(byArray, 8 * n4, byArray.length - 8 * n4);
        }
        int n5 = n;
        while (n3 >= 128) {
            for (n4 = 0; n4 < 16; ++n4) {
                lArray4[n4] = TweetNacl.dl64(byArray2, 8 * n4 + n5, n2 - 8 * n4);
            }
            for (n4 = 0; n4 < 80; ++n4) {
                int n6;
                for (n6 = 0; n6 < 8; ++n6) {
                    lArray2[n6] = lArray3[n6];
                }
                long l = lArray3[7] + TweetNacl.Sigma1(lArray3[4]) + TweetNacl.Ch(lArray3[4], lArray3[5], lArray3[6]) + K[n4] + lArray4[n4 % 16];
                lArray2[7] = l + TweetNacl.Sigma0(lArray3[0]) + TweetNacl.Maj(lArray3[0], lArray3[1], lArray3[2]);
                lArray2[3] = lArray2[3] + l;
                for (n6 = 0; n6 < 8; ++n6) {
                    lArray3[(n6 + 1) % 8] = lArray2[n6];
                }
                if (n4 % 16 != 15) continue;
                for (n6 = 0; n6 < 16; ++n6) {
                    int n7 = n6;
                    lArray4[n7] = lArray4[n7] + (lArray4[(n6 + 9) % 16] + TweetNacl.sigma0(lArray4[(n6 + 1) % 16]) + TweetNacl.sigma1(lArray4[(n6 + 14) % 16]));
                }
            }
            for (n4 = 0; n4 < 8; ++n4) {
                int n8 = n4;
                lArray3[n8] = lArray3[n8] + lArray[n4];
                lArray[n4] = lArray3[n4];
            }
            n5 += 128;
            n3 -= 128;
        }
        for (n4 = 0; n4 < 8; ++n4) {
            TweetNacl.ts64(byArray, 8 * n4, byArray.length - 8 * n4, lArray[n4]);
        }
        return n3;
    }

    public static int crypto_hashblocks(byte[] byArray, byte[] byArray2, int n) {
        return TweetNacl.crypto_hashblocks(byArray, byArray2, 0, byArray2.length, n);
    }

    private static int crypto_hash(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4;
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[256];
        long l = n3;
        for (n4 = 0; n4 < 64; ++n4) {
            byArray3[n4] = iv[n4];
        }
        TweetNacl.crypto_hashblocks(byArray3, byArray2, n, n2, n3);
        n3 &= 0x7F;
        for (n4 = 0; n4 < 256; ++n4) {
            byArray4[n4] = 0;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            byArray4[n4] = byArray2[n4 + n];
        }
        byArray4[n3] = -128;
        n3 = 256 - 128 * (n3 < 112 ? 1 : 0);
        byArray4[n3 - 9] = (byte)(l >>> 61);
        TweetNacl.ts64(byArray4, n3 - 8, byArray4.length - (n3 - 8), l << 3);
        TweetNacl.crypto_hashblocks(byArray3, byArray4, 0, byArray4.length, n3);
        for (n4 = 0; n4 < 64; ++n4) {
            byArray[n4] = byArray3[n4];
        }
        return 0;
    }

    public static int crypto_hash(byte[] byArray, byte[] byArray2, int n) {
        return TweetNacl.crypto_hash(byArray, byArray2, 0, byArray2.length, n);
    }

    public static int crypto_hash(byte[] byArray, byte[] byArray2) {
        return TweetNacl.crypto_hash(byArray, byArray2, byArray2 != null ? byArray2.length : 0);
    }

    private static void add(long[][] lArray, long[][] lArray2) {
        long[] lArray3 = new long[16];
        long[] lArray4 = new long[16];
        long[] lArray5 = new long[16];
        long[] lArray6 = new long[16];
        long[] lArray7 = new long[16];
        long[] lArray8 = new long[16];
        long[] lArray9 = new long[16];
        long[] lArray10 = new long[16];
        long[] lArray11 = new long[16];
        long[] lArray12 = lArray[0];
        long[] lArray13 = lArray[1];
        long[] lArray14 = lArray[2];
        long[] lArray15 = lArray[3];
        long[] lArray16 = lArray2[0];
        long[] lArray17 = lArray2[1];
        long[] lArray18 = lArray2[2];
        long[] lArray19 = lArray2[3];
        TweetNacl.Z(lArray3, 0, lArray3.length, lArray13, 0, lArray13.length, lArray12, 0, lArray12.length);
        TweetNacl.Z(lArray7, 0, lArray7.length, lArray17, 0, lArray17.length, lArray16, 0, lArray16.length);
        TweetNacl.M(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length, lArray7, 0, lArray7.length);
        TweetNacl.A(lArray4, 0, lArray4.length, lArray12, 0, lArray12.length, lArray13, 0, lArray13.length);
        TweetNacl.A(lArray7, 0, lArray7.length, lArray16, 0, lArray16.length, lArray17, 0, lArray17.length);
        TweetNacl.M(lArray4, 0, lArray4.length, lArray4, 0, lArray4.length, lArray7, 0, lArray7.length);
        TweetNacl.M(lArray5, 0, lArray5.length, lArray15, 0, lArray15.length, lArray19, 0, lArray19.length);
        TweetNacl.M(lArray5, 0, lArray5.length, lArray5, 0, lArray5.length, D2, 0, D2.length);
        TweetNacl.M(lArray6, 0, lArray6.length, lArray14, 0, lArray14.length, lArray18, 0, lArray18.length);
        TweetNacl.A(lArray6, 0, lArray6.length, lArray6, 0, lArray6.length, lArray6, 0, lArray6.length);
        TweetNacl.Z(lArray8, 0, lArray8.length, lArray4, 0, lArray4.length, lArray3, 0, lArray3.length);
        TweetNacl.Z(lArray9, 0, lArray9.length, lArray6, 0, lArray6.length, lArray5, 0, lArray5.length);
        TweetNacl.A(lArray10, 0, lArray10.length, lArray6, 0, lArray6.length, lArray5, 0, lArray5.length);
        TweetNacl.A(lArray11, 0, lArray11.length, lArray4, 0, lArray4.length, lArray3, 0, lArray3.length);
        TweetNacl.M(lArray12, 0, lArray12.length, lArray8, 0, lArray8.length, lArray9, 0, lArray9.length);
        TweetNacl.M(lArray13, 0, lArray13.length, lArray11, 0, lArray11.length, lArray10, 0, lArray10.length);
        TweetNacl.M(lArray14, 0, lArray14.length, lArray10, 0, lArray10.length, lArray9, 0, lArray9.length);
        TweetNacl.M(lArray15, 0, lArray15.length, lArray8, 0, lArray8.length, lArray11, 0, lArray11.length);
    }

    private static void cswap(long[][] lArray, long[][] lArray2, byte by) {
        for (int i = 0; i < 4; ++i) {
            TweetNacl.sel25519(lArray[i], 0, lArray[i].length, lArray2[i], 0, lArray2[i].length, by);
        }
    }

    private static void pack(byte[] byArray, long[][] lArray) {
        long[] lArray2 = new long[16];
        long[] lArray3 = new long[16];
        long[] lArray4 = new long[16];
        TweetNacl.inv25519(lArray4, 0, lArray4.length, lArray[2], 0, lArray[2].length);
        TweetNacl.M(lArray2, 0, lArray2.length, lArray[0], 0, lArray[0].length, lArray4, 0, lArray4.length);
        TweetNacl.M(lArray3, 0, lArray3.length, lArray[1], 0, lArray[1].length, lArray4, 0, lArray4.length);
        TweetNacl.pack25519(byArray, lArray3, 0, lArray3.length);
        byArray[31] = (byte)(byArray[31] ^ TweetNacl.par25519(lArray2) << 7);
    }

    private static void scalarmult(long[][] lArray, long[][] lArray2, byte[] byArray, int n, int n2) {
        TweetNacl.set25519(lArray[0], gf0);
        TweetNacl.set25519(lArray[1], gf1);
        TweetNacl.set25519(lArray[2], gf1);
        TweetNacl.set25519(lArray[3], gf0);
        for (int i = 255; i >= 0; --i) {
            byte by = (byte)(byArray[i / 8 + n] >> (i & 7) & 1);
            TweetNacl.cswap(lArray, lArray2, by);
            TweetNacl.add(lArray2, lArray);
            TweetNacl.add(lArray, lArray);
            TweetNacl.cswap(lArray, lArray2, by);
        }
    }

    private static void scalarbase(long[][] lArray, byte[] byArray, int n, int n2) {
        long[][] lArrayArray = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        TweetNacl.set25519(lArrayArray[0], X);
        TweetNacl.set25519(lArrayArray[1], Y);
        TweetNacl.set25519(lArrayArray[2], gf1);
        TweetNacl.M(lArrayArray[3], 0, lArrayArray[3].length, X, 0, X.length, Y, 0, Y.length);
        TweetNacl.scalarmult(lArray, lArrayArray, byArray, n, n2);
    }

    public static int crypto_sign_keypair(byte[] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3 = new byte[64];
        long[][] lArrayArray = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        if (!bl) {
            TweetNacl.randombytes(byArray2, 32);
        }
        TweetNacl.crypto_hash(byArray3, byArray2, 0, byArray2.length, 32);
        byArray3[0] = (byte)(byArray3[0] & 0xF8);
        byArray3[31] = (byte)(byArray3[31] & 0x7F);
        byArray3[31] = (byte)(byArray3[31] | 0x40);
        TweetNacl.scalarbase(lArrayArray, byArray3, 0, byArray3.length);
        TweetNacl.pack(byArray, lArrayArray);
        for (int i = 0; i < 32; ++i) {
            byArray2[i + 32] = byArray[i];
        }
        return 0;
    }

    private static void modL(byte[] byArray, int n, int n2, long[] lArray) {
        int n3;
        long l;
        int n4;
        for (n4 = 63; n4 >= 32; --n4) {
            l = 0L;
            n3 = n4 - 32;
            while (n3 < n4 - 12) {
                int n5 = n3;
                lArray[n5] = lArray[n5] + (l - 16L * lArray[n4] * L[n3 - (n4 - 32)]);
                l = lArray[n3] + 128L >> 8;
                int n6 = n3++;
                lArray[n6] = lArray[n6] - (l << 8);
            }
            int n7 = n3;
            lArray[n7] = lArray[n7] + l;
            lArray[n4] = 0L;
        }
        l = 0L;
        n3 = 0;
        while (n3 < 32) {
            int n8 = n3;
            lArray[n8] = lArray[n8] + (l - (lArray[31] >> 4) * L[n3]);
            l = lArray[n3] >> 8;
            int n9 = n3++;
            lArray[n9] = lArray[n9] & 0xFFL;
        }
        for (n3 = 0; n3 < 32; ++n3) {
            int n10 = n3;
            lArray[n10] = lArray[n10] - l * L[n3];
        }
        for (n4 = 0; n4 < 32; ++n4) {
            int n11 = n4 + 1;
            lArray[n11] = lArray[n11] + (lArray[n4] >> 8);
            byArray[n4 + n] = (byte)(lArray[n4] & 0xFFL);
        }
    }

    private static void reduce(byte[] byArray) {
        int n;
        long[] lArray = new long[64];
        for (n = 0; n < 64; ++n) {
            lArray[n] = byArray[n] & 0xFF;
        }
        for (n = 0; n < 64; ++n) {
            byArray[n] = 0;
        }
        TweetNacl.modL(byArray, 0, byArray.length, lArray);
    }

    public static int crypto_sign(byte[] byArray, long l, byte[] byArray2, int n, byte[] byArray3) {
        int n2;
        byte[] byArray4 = new byte[64];
        byte[] byArray5 = new byte[64];
        byte[] byArray6 = new byte[64];
        long[] lArray = new long[64];
        long[][] lArrayArray = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        TweetNacl.crypto_hash(byArray4, byArray3, 0, byArray3.length, 32);
        byArray4[0] = (byte)(byArray4[0] & 0xF8);
        byArray4[31] = (byte)(byArray4[31] & 0x7F);
        byArray4[31] = (byte)(byArray4[31] | 0x40);
        for (n2 = 0; n2 < n; ++n2) {
            byArray[64 + n2] = byArray2[n2];
        }
        for (n2 = 0; n2 < 32; ++n2) {
            byArray[32 + n2] = byArray4[32 + n2];
        }
        TweetNacl.crypto_hash(byArray6, byArray, 32, byArray.length - 32, n + 32);
        TweetNacl.reduce(byArray6);
        TweetNacl.scalarbase(lArrayArray, byArray6, 0, byArray6.length);
        TweetNacl.pack(byArray, lArrayArray);
        for (n2 = 0; n2 < 32; ++n2) {
            byArray[n2 + 32] = byArray3[n2 + 32];
        }
        TweetNacl.crypto_hash(byArray5, byArray, 0, byArray.length, n + 64);
        TweetNacl.reduce(byArray5);
        for (n2 = 0; n2 < 64; ++n2) {
            lArray[n2] = 0L;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            lArray[n2] = byArray6[n2] & 0xFF;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            for (int i = 0; i < 32; ++i) {
                int n3 = n2 + i;
                lArray[n3] = lArray[n3] + (long)(byArray5[n2] & 0xFF) * (long)(byArray4[i] & 0xFF);
            }
        }
        TweetNacl.modL(byArray, 32, byArray.length - 32, lArray);
        return 0;
    }

    private static int unpackneg(long[][] lArray, byte[] byArray) {
        long[] lArray2 = new long[16];
        long[] lArray3 = new long[16];
        long[] lArray4 = new long[16];
        long[] lArray5 = new long[16];
        long[] lArray6 = new long[16];
        long[] lArray7 = new long[16];
        long[] lArray8 = new long[16];
        TweetNacl.set25519(lArray[2], gf1);
        TweetNacl.unpack25519(lArray[1], byArray);
        TweetNacl.S(lArray4, 0, lArray4.length, lArray[1], 0, lArray[1].length);
        TweetNacl.M(lArray5, 0, lArray5.length, lArray4, 0, lArray4.length, D, 0, D.length);
        TweetNacl.Z(lArray4, 0, lArray4.length, lArray4, 0, lArray4.length, lArray[2], 0, lArray[2].length);
        TweetNacl.A(lArray5, 0, lArray5.length, lArray[2], 0, lArray[2].length, lArray5, 0, lArray5.length);
        TweetNacl.S(lArray6, 0, lArray6.length, lArray5, 0, lArray5.length);
        TweetNacl.S(lArray7, 0, lArray7.length, lArray6, 0, lArray6.length);
        TweetNacl.M(lArray8, 0, lArray8.length, lArray7, 0, lArray7.length, lArray6, 0, lArray6.length);
        TweetNacl.M(lArray2, 0, lArray2.length, lArray8, 0, lArray8.length, lArray4, 0, lArray4.length);
        TweetNacl.M(lArray2, 0, lArray2.length, lArray2, 0, lArray2.length, lArray5, 0, lArray5.length);
        TweetNacl.pow2523(lArray2, lArray2);
        TweetNacl.M(lArray2, 0, lArray2.length, lArray2, 0, lArray2.length, lArray4, 0, lArray4.length);
        TweetNacl.M(lArray2, 0, lArray2.length, lArray2, 0, lArray2.length, lArray5, 0, lArray5.length);
        TweetNacl.M(lArray2, 0, lArray2.length, lArray2, 0, lArray2.length, lArray5, 0, lArray5.length);
        TweetNacl.M(lArray[0], 0, lArray[0].length, lArray2, 0, lArray2.length, lArray5, 0, lArray5.length);
        TweetNacl.S(lArray3, 0, lArray3.length, lArray[0], 0, lArray[0].length);
        TweetNacl.M(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length, lArray5, 0, lArray5.length);
        if (TweetNacl.neq25519(lArray3, lArray4) != 0) {
            TweetNacl.M(lArray[0], 0, lArray[0].length, lArray[0], 0, lArray[0].length, I, 0, I.length);
        }
        TweetNacl.S(lArray3, 0, lArray3.length, lArray[0], 0, lArray[0].length);
        TweetNacl.M(lArray3, 0, lArray3.length, lArray3, 0, lArray3.length, lArray5, 0, lArray5.length);
        if (TweetNacl.neq25519(lArray3, lArray4) != 0) {
            return -1;
        }
        if (TweetNacl.par25519(lArray[0]) == (byArray[31] & 0xFF) >> 7) {
            TweetNacl.Z(lArray[0], 0, lArray[0].length, gf0, 0, gf0.length, lArray[0], 0, lArray[0].length);
        }
        TweetNacl.M(lArray[3], 0, lArray[3].length, lArray[0], 0, lArray[0].length, lArray[1], 0, lArray[1].length);
        return 0;
    }

    public static int crypto_sign_open(byte[] byArray, long l, byte[] byArray2, int n, byte[] byArray3) {
        int n2;
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[64];
        long[][] lArrayArray = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        long[][] lArrayArray2 = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        if (n < 64) {
            return -1;
        }
        if (TweetNacl.unpackneg(lArrayArray2, byArray3) != 0) {
            return -1;
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = byArray2[n2];
        }
        for (n2 = 0; n2 < 32; ++n2) {
            byArray[n2 + 32] = byArray3[n2];
        }
        TweetNacl.crypto_hash(byArray5, byArray, 0, byArray.length, n);
        TweetNacl.reduce(byArray5);
        TweetNacl.scalarmult(lArrayArray, lArrayArray2, byArray5, 0, byArray5.length);
        TweetNacl.scalarbase(lArrayArray2, byArray2, 32, byArray2.length - 32);
        TweetNacl.add(lArrayArray, lArrayArray2);
        TweetNacl.pack(byArray4, lArrayArray);
        n -= 64;
        if (TweetNacl.crypto_verify_32(byArray2, 0, byArray2.length, byArray4, 0, byArray4.length) != 0) {
            return -1;
        }
        return 0;
    }

    public static void randombytes(byte[] byArray, int n) {
        long l;
        int n2;
        int n3 = n % 8;
        for (n2 = 0; n2 < n - n3; n2 += 8) {
            l = jrandom.nextLong();
            byArray[n2 + 0] = (byte)(l >>> 0);
            byArray[n2 + 1] = (byte)(l >>> 8);
            byArray[n2 + 2] = (byte)(l >>> 16);
            byArray[n2 + 3] = (byte)(l >>> 24);
            byArray[n2 + 4] = (byte)(l >>> 32);
            byArray[n2 + 5] = (byte)(l >>> 40);
            byArray[n2 + 6] = (byte)(l >>> 48);
            byArray[n2 + 7] = (byte)(l >>> 56);
        }
        if (n3 > 0) {
            l = jrandom.nextLong();
            for (n2 = n - n3; n2 < n; ++n2) {
                byArray[n2] = (byte)(l >>> 8 * n2);
            }
        }
    }

    static {
        int n;
        _0 = new byte[16];
        _9 = new byte[32];
        for (n = 0; n < _0.length; ++n) {
            TweetNacl._0[n] = 0;
        }
        for (n = 0; n < _9.length; ++n) {
            TweetNacl._9[n] = 0;
        }
        TweetNacl._9[0] = 9;
        gf0 = new long[16];
        gf1 = new long[16];
        _121665 = new long[16];
        for (n = 0; n < gf0.length; ++n) {
            TweetNacl.gf0[n] = 0L;
        }
        for (n = 0; n < gf1.length; ++n) {
            TweetNacl.gf1[n] = 0L;
        }
        TweetNacl.gf1[0] = 1L;
        for (n = 0; n < _121665.length; ++n) {
            TweetNacl._121665[n] = 0L;
        }
        TweetNacl._121665[0] = 56129L;
        TweetNacl._121665[1] = 1L;
        D = new long[]{30883L, 4953L, 19914L, 30187L, 55467L, 16705L, 2637L, 112L, 59544L, 30585L, 16505L, 36039L, 65139L, 11119L, 27886L, 20995L};
        D2 = new long[]{61785L, 9906L, 39828L, 60374L, 45398L, 33411L, 5274L, 224L, 53552L, 61171L, 33010L, 6542L, 64743L, 22239L, 55772L, 9222L};
        X = new long[]{54554L, 36645L, 11616L, 51542L, 42930L, 38181L, 51040L, 26924L, 56412L, 64982L, 57905L, 49316L, 21502L, 52590L, 14035L, 8553L};
        Y = new long[]{26200L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L};
        I = new long[]{41136L, 18958L, 6951L, 50414L, 58488L, 44335L, 6150L, 12099L, 55207L, 15867L, 153L, 11085L, 57099L, 20417L, 9344L, 11139L};
        sigma = new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107};
        K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
        iv = new byte[]{106, 9, -26, 103, -13, -68, -55, 8, -69, 103, -82, -123, -124, -54, -89, 59, 60, 110, -13, 114, -2, -108, -8, 43, -91, 79, -11, 58, 95, 29, 54, -15, 81, 14, 82, 127, -83, -26, -126, -47, -101, 5, 104, -116, 43, 62, 108, 31, 31, -125, -39, -85, -5, 65, -67, 107, 91, -32, -51, 25, 19, 126, 33, 121};
        L = new long[]{237L, 211L, 245L, 92L, 26L, 99L, 18L, 88L, 214L, 156L, 247L, 162L, 222L, 249L, 222L, 20L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 16L};
        jrandom = new SecureRandom();
    }

    public static final class poly1305 {
        private byte[] buffer = new byte[16];
        private int[] r = new int[10];
        private int[] h = new int[10];
        private int[] pad = new int[8];
        private int leftover = 0;
        private int fin = 0;

        public poly1305(byte[] byArray) {
            int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            this.r[0] = n & 0x1FFF;
            int n2 = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
            this.r[1] = (n >>> 13 | n2 << 3) & 0x1FFF;
            int n3 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
            this.r[2] = (n2 >>> 10 | n3 << 6) & 0x1F03;
            int n4 = byArray[6] & 0xFF | (byArray[7] & 0xFF) << 8;
            this.r[3] = (n3 >>> 7 | n4 << 9) & 0x1FFF;
            int n5 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8;
            this.r[4] = (n4 >>> 4 | n5 << 12) & 0xFF;
            this.r[5] = n5 >>> 1 & 0x1FFE;
            int n6 = byArray[10] & 0xFF | (byArray[11] & 0xFF) << 8;
            this.r[6] = (n5 >>> 14 | n6 << 2) & 0x1FFF;
            int n7 = byArray[12] & 0xFF | (byArray[13] & 0xFF) << 8;
            this.r[7] = (n6 >>> 11 | n7 << 5) & 0x1F81;
            int n8 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
            this.r[8] = (n7 >>> 8 | n8 << 8) & 0x1FFF;
            this.r[9] = n8 >>> 5 & 0x7F;
            this.pad[0] = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8;
            this.pad[1] = byArray[18] & 0xFF | (byArray[19] & 0xFF) << 8;
            this.pad[2] = byArray[20] & 0xFF | (byArray[21] & 0xFF) << 8;
            this.pad[3] = byArray[22] & 0xFF | (byArray[23] & 0xFF) << 8;
            this.pad[4] = byArray[24] & 0xFF | (byArray[25] & 0xFF) << 8;
            this.pad[5] = byArray[26] & 0xFF | (byArray[27] & 0xFF) << 8;
            this.pad[6] = byArray[28] & 0xFF | (byArray[29] & 0xFF) << 8;
            this.pad[7] = byArray[30] & 0xFF | (byArray[31] & 0xFF) << 8;
        }

        public poly1305 blocks(byte[] byArray, int n, int n2) {
            int n3 = this.fin != 0 ? 0 : 2048;
            int n4 = this.h[0];
            int n5 = this.h[1];
            int n6 = this.h[2];
            int n7 = this.h[3];
            int n8 = this.h[4];
            int n9 = this.h[5];
            int n10 = this.h[6];
            int n11 = this.h[7];
            int n12 = this.h[8];
            int n13 = this.h[9];
            int n14 = this.r[0];
            int n15 = this.r[1];
            int n16 = this.r[2];
            int n17 = this.r[3];
            int n18 = this.r[4];
            int n19 = this.r[5];
            int n20 = this.r[6];
            int n21 = this.r[7];
            int n22 = this.r[8];
            int n23 = this.r[9];
            while (n2 >= 16) {
                int n24;
                int n25 = byArray[n + 0] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
                n4 += n25 & 0x1FFF;
                int n26 = byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8;
                n5 += (n25 >>> 13 | n26 << 3) & 0x1FFF;
                int n27 = byArray[n + 4] & 0xFF | (byArray[n + 5] & 0xFF) << 8;
                n6 += (n26 >>> 10 | n27 << 6) & 0x1FFF;
                int n28 = byArray[n + 6] & 0xFF | (byArray[n + 7] & 0xFF) << 8;
                n7 += (n27 >>> 7 | n28 << 9) & 0x1FFF;
                int n29 = byArray[n + 8] & 0xFF | (byArray[n + 9] & 0xFF) << 8;
                n8 += (n28 >>> 4 | n29 << 12) & 0x1FFF;
                n9 += n29 >>> 1 & 0x1FFF;
                int n30 = byArray[n + 10] & 0xFF | (byArray[n + 11] & 0xFF) << 8;
                n10 += (n29 >>> 14 | n30 << 2) & 0x1FFF;
                int n31 = byArray[n + 12] & 0xFF | (byArray[n + 13] & 0xFF) << 8;
                n11 += (n30 >>> 11 | n31 << 5) & 0x1FFF;
                int n32 = byArray[n + 14] & 0xFF | (byArray[n + 15] & 0xFF) << 8;
                n12 += (n31 >>> 8 | n32 << 8) & 0x1FFF;
                n13 += n32 >>> 5 | n3;
                int n33 = n24 = 0;
                n33 += n4 * n14;
                n33 += n5 * (5 * n23);
                n33 += n6 * (5 * n22);
                n33 += n7 * (5 * n21);
                n24 = (n33 += n8 * (5 * n20)) >>> 13;
                n33 &= 0x1FFF;
                n33 += n9 * (5 * n19);
                n33 += n10 * (5 * n18);
                n33 += n11 * (5 * n17);
                n33 += n12 * (5 * n16);
                n33 &= 0x1FFF;
                int n34 = n24 += (n33 += n13 * (5 * n15)) >>> 13;
                n34 += n4 * n15;
                n34 += n5 * n14;
                n34 += n6 * (5 * n23);
                n34 += n7 * (5 * n22);
                n24 = (n34 += n8 * (5 * n21)) >>> 13;
                n34 &= 0x1FFF;
                n34 += n9 * (5 * n20);
                n34 += n10 * (5 * n19);
                n34 += n11 * (5 * n18);
                n34 += n12 * (5 * n17);
                n34 &= 0x1FFF;
                int n35 = n24 += (n34 += n13 * (5 * n16)) >>> 13;
                n35 += n4 * n16;
                n35 += n5 * n15;
                n35 += n6 * n14;
                n35 += n7 * (5 * n23);
                n24 = (n35 += n8 * (5 * n22)) >>> 13;
                n35 &= 0x1FFF;
                n35 += n9 * (5 * n21);
                n35 += n10 * (5 * n20);
                n35 += n11 * (5 * n19);
                n35 += n12 * (5 * n18);
                n35 &= 0x1FFF;
                int n36 = n24 += (n35 += n13 * (5 * n17)) >>> 13;
                n36 += n4 * n17;
                n36 += n5 * n16;
                n36 += n6 * n15;
                n36 += n7 * n14;
                n24 = (n36 += n8 * (5 * n23)) >>> 13;
                n36 &= 0x1FFF;
                n36 += n9 * (5 * n22);
                n36 += n10 * (5 * n21);
                n36 += n11 * (5 * n20);
                n36 += n12 * (5 * n19);
                n36 &= 0x1FFF;
                int n37 = n24 += (n36 += n13 * (5 * n18)) >>> 13;
                n37 += n4 * n18;
                n37 += n5 * n17;
                n37 += n6 * n16;
                n37 += n7 * n15;
                n24 = (n37 += n8 * n14) >>> 13;
                n37 &= 0x1FFF;
                n37 += n9 * (5 * n23);
                n37 += n10 * (5 * n22);
                n37 += n11 * (5 * n21);
                n37 += n12 * (5 * n20);
                n37 &= 0x1FFF;
                int n38 = n24 += (n37 += n13 * (5 * n19)) >>> 13;
                n38 += n4 * n19;
                n38 += n5 * n18;
                n38 += n6 * n17;
                n38 += n7 * n16;
                n24 = (n38 += n8 * n15) >>> 13;
                n38 &= 0x1FFF;
                n38 += n9 * n14;
                n38 += n10 * (5 * n23);
                n38 += n11 * (5 * n22);
                n38 += n12 * (5 * n21);
                n38 &= 0x1FFF;
                int n39 = n24 += (n38 += n13 * (5 * n20)) >>> 13;
                n39 += n4 * n20;
                n39 += n5 * n19;
                n39 += n6 * n18;
                n39 += n7 * n17;
                n24 = (n39 += n8 * n16) >>> 13;
                n39 &= 0x1FFF;
                n39 += n9 * n15;
                n39 += n10 * n14;
                n39 += n11 * (5 * n23);
                n39 += n12 * (5 * n22);
                n39 &= 0x1FFF;
                int n40 = n24 += (n39 += n13 * (5 * n21)) >>> 13;
                n40 += n4 * n21;
                n40 += n5 * n20;
                n40 += n6 * n19;
                n40 += n7 * n18;
                n24 = (n40 += n8 * n17) >>> 13;
                n40 &= 0x1FFF;
                n40 += n9 * n16;
                n40 += n10 * n15;
                n40 += n11 * n14;
                n40 += n12 * (5 * n23);
                n40 &= 0x1FFF;
                int n41 = n24 += (n40 += n13 * (5 * n22)) >>> 13;
                n41 += n4 * n22;
                n41 += n5 * n21;
                n41 += n6 * n20;
                n41 += n7 * n19;
                n24 = (n41 += n8 * n18) >>> 13;
                n41 &= 0x1FFF;
                n41 += n9 * n17;
                n41 += n10 * n16;
                n41 += n11 * n15;
                n41 += n12 * n14;
                n41 &= 0x1FFF;
                int n42 = n24 += (n41 += n13 * (5 * n23)) >>> 13;
                n42 += n4 * n23;
                n42 += n5 * n22;
                n42 += n6 * n21;
                n42 += n7 * n20;
                n24 = (n42 += n8 * n19) >>> 13;
                n42 &= 0x1FFF;
                n42 += n9 * n18;
                n42 += n10 * n17;
                n42 += n11 * n16;
                n42 += n12 * n15;
                n24 += (n42 += n13 * n14) >>> 13;
                n42 &= 0x1FFF;
                n24 = (n24 << 2) + n24 | 0;
                n24 = n24 + n33 | 0;
                n33 = n24 & 0x1FFF;
                n4 = n33;
                n5 = n34 += (n24 >>>= 13);
                n6 = n35;
                n7 = n36;
                n8 = n37;
                n9 = n38;
                n10 = n39;
                n11 = n40;
                n12 = n41;
                n13 = n42;
                n += 16;
                n2 -= 16;
            }
            this.h[0] = n4;
            this.h[1] = n5;
            this.h[2] = n6;
            this.h[3] = n7;
            this.h[4] = n8;
            this.h[5] = n9;
            this.h[6] = n10;
            this.h[7] = n11;
            this.h[8] = n12;
            this.h[9] = n13;
            return this;
        }

        public poly1305 finish(byte[] byArray, int n) {
            int n2;
            int[] nArray = new int[10];
            if (this.leftover != 0) {
                n2 = this.leftover;
                this.buffer[n2++] = 1;
                while (n2 < 16) {
                    this.buffer[n2] = 0;
                    ++n2;
                }
                this.fin = 1;
                this.blocks(this.buffer, 0, 16);
            }
            int n3 = this.h[1] >>> 13;
            this.h[1] = this.h[1] & 0x1FFF;
            n2 = 2;
            while (n2 < 10) {
                int n4 = n2;
                this.h[n4] = this.h[n4] + n3;
                n3 = this.h[n2] >>> 13;
                int n5 = n2++;
                this.h[n5] = this.h[n5] & 0x1FFF;
            }
            this.h[0] = this.h[0] + n3 * 5;
            n3 = this.h[0] >>> 13;
            this.h[0] = this.h[0] & 0x1FFF;
            this.h[1] = this.h[1] + n3;
            n3 = this.h[1] >>> 13;
            this.h[1] = this.h[1] & 0x1FFF;
            this.h[2] = this.h[2] + n3;
            nArray[0] = this.h[0] + 5;
            n3 = nArray[0] >>> 13;
            nArray[0] = nArray[0] & 0x1FFF;
            n2 = 1;
            while (n2 < 10) {
                nArray[n2] = this.h[n2] + n3;
                n3 = nArray[n2] >>> 13;
                int n6 = n2++;
                nArray[n6] = nArray[n6] & 0x1FFF;
            }
            nArray[9] = nArray[9] - 8192;
            nArray[9] = nArray[9] & 0xFFFF;
            int n7 = (nArray[9] >>> 15) - 1;
            n7 &= 0xFFFF;
            n2 = 0;
            while (n2 < 10) {
                int n8 = n2++;
                nArray[n8] = nArray[n8] & n7;
            }
            n7 ^= 0xFFFFFFFF;
            for (n2 = 0; n2 < 10; ++n2) {
                this.h[n2] = this.h[n2] & n7 | nArray[n2];
            }
            this.h[0] = (this.h[0] | this.h[1] << 13) & 0xFFFF;
            this.h[1] = (this.h[1] >>> 3 | this.h[2] << 10) & 0xFFFF;
            this.h[2] = (this.h[2] >>> 6 | this.h[3] << 7) & 0xFFFF;
            this.h[3] = (this.h[3] >>> 9 | this.h[4] << 4) & 0xFFFF;
            this.h[4] = (this.h[4] >>> 12 | this.h[5] << 1 | this.h[6] << 14) & 0xFFFF;
            this.h[5] = (this.h[6] >>> 2 | this.h[7] << 11) & 0xFFFF;
            this.h[6] = (this.h[7] >>> 5 | this.h[8] << 8) & 0xFFFF;
            this.h[7] = (this.h[8] >>> 8 | this.h[9] << 5) & 0xFFFF;
            int n9 = this.h[0] + this.pad[0];
            this.h[0] = n9 & 0xFFFF;
            for (n2 = 1; n2 < 8; ++n2) {
                n9 = (this.h[n2] + this.pad[n2] | 0) + (n9 >>> 16) | 0;
                this.h[n2] = n9 & 0xFFFF;
            }
            byArray[n + 0] = (byte)(this.h[0] >>> 0 & 0xFF);
            byArray[n + 1] = (byte)(this.h[0] >>> 8 & 0xFF);
            byArray[n + 2] = (byte)(this.h[1] >>> 0 & 0xFF);
            byArray[n + 3] = (byte)(this.h[1] >>> 8 & 0xFF);
            byArray[n + 4] = (byte)(this.h[2] >>> 0 & 0xFF);
            byArray[n + 5] = (byte)(this.h[2] >>> 8 & 0xFF);
            byArray[n + 6] = (byte)(this.h[3] >>> 0 & 0xFF);
            byArray[n + 7] = (byte)(this.h[3] >>> 8 & 0xFF);
            byArray[n + 8] = (byte)(this.h[4] >>> 0 & 0xFF);
            byArray[n + 9] = (byte)(this.h[4] >>> 8 & 0xFF);
            byArray[n + 10] = (byte)(this.h[5] >>> 0 & 0xFF);
            byArray[n + 11] = (byte)(this.h[5] >>> 8 & 0xFF);
            byArray[n + 12] = (byte)(this.h[6] >>> 0 & 0xFF);
            byArray[n + 13] = (byte)(this.h[6] >>> 8 & 0xFF);
            byArray[n + 14] = (byte)(this.h[7] >>> 0 & 0xFF);
            byArray[n + 15] = (byte)(this.h[7] >>> 8 & 0xFF);
            return this;
        }

        public poly1305 update(byte[] byArray, int n, int n2) {
            int n3;
            int n4;
            if (this.leftover != 0) {
                n4 = 16 - this.leftover;
                if (n4 > n2) {
                    n4 = n2;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    this.buffer[this.leftover + n3] = byArray[n + n3];
                }
                n2 -= n4;
                n += n4;
                this.leftover += n4;
                if (this.leftover < 16) {
                    return this;
                }
                this.blocks(this.buffer, 0, 16);
                this.leftover = 0;
            }
            if (n2 >= 16) {
                n4 = n2 - n2 % 16;
                this.blocks(byArray, n, n4);
                n += n4;
                n2 -= n4;
            }
            if (n2 != 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    this.buffer[this.leftover + n3] = byArray[n + n3];
                }
                this.leftover += n2;
            }
            return this;
        }
    }

    public static final class Signature {
        private static final String TAG = "Signature";
        private byte[] theirPublicKey;
        private byte[] mySecretKey;
        public static final int publicKeyLength = 32;
        public static final int secretKeyLength = 64;
        public static final int seedLength = 32;
        public static final int signatureLength = 64;

        public Signature(byte[] byArray, byte[] byArray2) {
            this.theirPublicKey = byArray;
            this.mySecretKey = byArray2;
        }

        public byte[] sign(byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length + 64];
            TweetNacl.crypto_sign(byArray2, -1L, byArray, byArray.length, this.mySecretKey);
            return byArray2;
        }

        public byte[] open(byte[] byArray) {
            if (byArray == null || byArray.length <= 64) {
                return null;
            }
            byte[] byArray2 = new byte[byArray.length];
            if (0 != TweetNacl.crypto_sign_open(byArray2, -1L, byArray, byArray.length, this.theirPublicKey)) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length - 64];
            for (int i = 0; i < byArray3.length; ++i) {
                byArray3[i] = byArray[i + 64];
            }
            return byArray3;
        }

        public byte[] detached(byte[] byArray) {
            byte[] byArray2 = this.sign(byArray);
            byte[] byArray3 = new byte[64];
            for (int i = 0; i < byArray3.length; ++i) {
                byArray3[i] = byArray2[i];
            }
            return byArray3;
        }

        public boolean detached_verify(byte[] byArray, byte[] byArray2) {
            int n;
            if (byArray2.length != 64) {
                return false;
            }
            if (this.theirPublicKey.length != 32) {
                return false;
            }
            byte[] byArray3 = new byte[64 + byArray.length];
            byte[] byArray4 = new byte[64 + byArray.length];
            for (n = 0; n < 64; ++n) {
                byArray3[n] = byArray2[n];
            }
            for (n = 0; n < byArray.length; ++n) {
                byArray3[n + 64] = byArray[n];
            }
            return TweetNacl.crypto_sign_open(byArray4, -1L, byArray3, byArray3.length, this.theirPublicKey) >= 0;
        }

        public static KeyPair keyPair() {
            KeyPair keyPair = new KeyPair();
            TweetNacl.crypto_sign_keypair(keyPair.getPublicKey(), keyPair.getSecretKey(), false);
            return keyPair;
        }

        public static KeyPair keyPair_fromSecretKey(byte[] byArray) {
            int n;
            KeyPair keyPair = new KeyPair();
            byte[] byArray2 = keyPair.getPublicKey();
            byte[] byArray3 = keyPair.getSecretKey();
            for (n = 0; n < keyPair.getSecretKey().length; ++n) {
                byArray3[n] = byArray[n];
            }
            for (n = 0; n < keyPair.getPublicKey().length; ++n) {
                byArray2[n] = byArray[32 + n];
            }
            return keyPair;
        }

        public static KeyPair keyPair_fromSeed(byte[] byArray) {
            KeyPair keyPair = new KeyPair();
            byte[] byArray2 = keyPair.getPublicKey();
            byte[] byArray3 = keyPair.getSecretKey();
            for (int i = 0; i < 32; ++i) {
                byArray3[i] = byArray[i];
            }
            TweetNacl.crypto_sign_keypair(byArray2, byArray3, true);
            return keyPair;
        }

        public static class KeyPair {
            private byte[] publicKey = new byte[32];
            private byte[] secretKey = new byte[64];

            public byte[] getPublicKey() {
                return this.publicKey;
            }

            public byte[] getSecretKey() {
                return this.secretKey;
            }
        }
    }

    public static final class Hash {
        private static final String TAG = "Hash";
        public static final int hashLength = 64;

        public static byte[] sha512(byte[] byArray) {
            if (byArray == null || byArray.length <= 0) {
                return null;
            }
            byte[] byArray2 = new byte[64];
            TweetNacl.crypto_hash(byArray2, byArray);
            return byArray2;
        }

        public static byte[] sha512(String string) throws UnsupportedEncodingException {
            return Hash.sha512(string.getBytes("utf-8"));
        }
    }

    public static final class ScalarMult {
        private static final String TAG = "ScalarMult";
        public static final int scalarLength = 32;
        public static final int groupElementLength = 32;

        public static byte[] scalseMult(byte[] byArray, byte[] byArray2) {
            if (byArray.length != 32 || byArray2.length != 32) {
                return null;
            }
            byte[] byArray3 = new byte[32];
            TweetNacl.crypto_scalarmult(byArray3, byArray, byArray2);
            return byArray3;
        }

        public static byte[] scalseMult_base(byte[] byArray) {
            if (byArray.length != 32) {
                return null;
            }
            byte[] byArray2 = new byte[32];
            TweetNacl.crypto_scalarmult_base(byArray2, byArray);
            return byArray2;
        }
    }

    public static final class SecretBox {
        private static final String TAG = "SecretBox";
        private AtomicLong nonce;
        private byte[] key;
        public static final int keyLength = 32;
        public static final int nonceLength = 24;
        public static final int overheadLength = 16;
        public static final int zerobytesLength = 32;
        public static final int boxzerobytesLength = 16;

        public SecretBox(byte[] byArray) {
            this(byArray, 68L);
        }

        public SecretBox(byte[] byArray, long l) {
            this.key = byArray;
            this.nonce = new AtomicLong(l);
        }

        public void setNonce(long l) {
            this.nonce.set(l);
        }

        public long getNonce() {
            return this.nonce.get();
        }

        public long incrNonce() {
            return this.nonce.incrementAndGet();
        }

        private byte[] generateNonce() {
            long l = this.nonce.get();
            byte[] byArray = new byte[24];
            for (int i = 0; i < 24; i += 8) {
                byArray[i + 0] = (byte)(l >>> 0);
                byArray[i + 1] = (byte)(l >>> 8);
                byArray[i + 2] = (byte)(l >>> 16);
                byArray[i + 3] = (byte)(l >>> 24);
                byArray[i + 4] = (byte)(l >>> 32);
                byArray[i + 5] = (byte)(l >>> 40);
                byArray[i + 6] = (byte)(l >>> 48);
                byArray[i + 7] = (byte)(l >>> 56);
            }
            return byArray;
        }

        public byte[] box(byte[] byArray) {
            return this.box(byArray, this.generateNonce());
        }

        public byte[] box(byte[] byArray, byte[] byArray2) {
            if (byArray == null || byArray.length <= 0 || byArray2 == null || byArray2.length != 24) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length + 32];
            byte[] byArray4 = new byte[byArray3.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray3[i + 32] = byArray[i];
            }
            if (0 != TweetNacl.crypto_secretbox(byArray4, byArray3, byArray3.length, byArray2, this.key)) {
                return null;
            }
            byte[] byArray5 = new byte[byArray4.length - 16];
            for (int i = 0; i < byArray5.length; ++i) {
                byArray5[i] = byArray4[i + 16];
            }
            return byArray5;
        }

        public byte[] open(byte[] byArray) {
            return this.open(byArray, this.generateNonce());
        }

        public byte[] open(byte[] byArray, byte[] byArray2) {
            if (byArray == null || byArray.length <= 16 || byArray2 == null || byArray2.length != 24) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length + 16];
            byte[] byArray4 = new byte[byArray3.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray3[i + 16] = byArray[i];
            }
            if (0 != TweetNacl.crypto_secretbox_open(byArray4, byArray3, byArray3.length, byArray2, this.key)) {
                return null;
            }
            byte[] byArray5 = new byte[byArray4.length - 32];
            for (int i = 0; i < byArray5.length; ++i) {
                byArray5[i] = byArray4[i + 32];
            }
            return byArray5;
        }
    }

    public static final class Box {
        private static final String TAG = "Box";
        private AtomicLong nonce;
        private byte[] theirPublicKey;
        private byte[] mySecretKey;
        private byte[] sharedKey;
        public static final int publicKeyLength = 32;
        public static final int secretKeyLength = 32;
        public static final int sharedKeyLength = 32;
        public static final int nonceLength = 24;
        public static final int zerobytesLength = 32;
        public static final int boxzerobytesLength = 16;
        public static final int overheadLength = 16;

        public Box(byte[] byArray, byte[] byArray2) {
            this(byArray, byArray2, 68L);
        }

        public Box(byte[] byArray, byte[] byArray2, long l) {
            this.theirPublicKey = byArray;
            this.mySecretKey = byArray2;
            this.nonce = new AtomicLong(l);
            this.before();
        }

        public void setNonce(long l) {
            this.nonce.set(l);
        }

        public long getNonce() {
            return this.nonce.get();
        }

        public long incrNonce() {
            return this.nonce.incrementAndGet();
        }

        private byte[] generateNonce() {
            long l = this.nonce.get();
            byte[] byArray = new byte[24];
            for (int i = 0; i < 24; i += 8) {
                byArray[i + 0] = (byte)(l >>> 0);
                byArray[i + 1] = (byte)(l >>> 8);
                byArray[i + 2] = (byte)(l >>> 16);
                byArray[i + 3] = (byte)(l >>> 24);
                byArray[i + 4] = (byte)(l >>> 32);
                byArray[i + 5] = (byte)(l >>> 40);
                byArray[i + 6] = (byte)(l >>> 48);
                byArray[i + 7] = (byte)(l >>> 56);
            }
            return byArray;
        }

        public byte[] box(byte[] byArray) {
            return this.box(byArray, this.generateNonce());
        }

        public byte[] box(byte[] byArray, byte[] byArray2) {
            if (byArray == null || byArray.length <= 0 || byArray2 == null || byArray2.length != 24) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length + 32];
            byte[] byArray4 = new byte[byArray3.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray3[i + 32] = byArray[i];
            }
            if (0 != TweetNacl.crypto_box(byArray4, byArray3, byArray3.length, byArray2, this.theirPublicKey, this.mySecretKey)) {
                return null;
            }
            byte[] byArray5 = new byte[byArray4.length - 16];
            for (int i = 0; i < byArray5.length; ++i) {
                byArray5[i] = byArray4[i + 16];
            }
            return byArray5;
        }

        public byte[] open(byte[] byArray) {
            return this.open(byArray, this.generateNonce());
        }

        public byte[] open(byte[] byArray, byte[] byArray2) {
            if (byArray == null || byArray.length <= 16 || byArray2 == null || byArray2.length != 24) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length + 16];
            byte[] byArray4 = new byte[byArray3.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray3[i + 16] = byArray[i];
            }
            if (0 != TweetNacl.crypto_box_open(byArray4, byArray3, byArray3.length, byArray2, this.theirPublicKey, this.mySecretKey)) {
                return null;
            }
            byte[] byArray5 = new byte[byArray4.length - 32];
            for (int i = 0; i < byArray5.length; ++i) {
                byArray5[i] = byArray4[i + 32];
            }
            return byArray5;
        }

        public byte[] before() {
            if (this.sharedKey == null) {
                this.sharedKey = new byte[32];
                TweetNacl.crypto_box_beforenm(this.sharedKey, this.theirPublicKey, this.mySecretKey);
            }
            return this.sharedKey;
        }

        public byte[] after(byte[] byArray) {
            return this.after(byArray, this.generateNonce());
        }

        public byte[] after(byte[] byArray, byte[] byArray2) {
            if (byArray == null || byArray.length <= 0 || byArray2 == null || byArray2.length != 24) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length + 32];
            byte[] byArray4 = new byte[byArray3.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray3[i + 32] = byArray[i];
            }
            if (0 != TweetNacl.crypto_box_afternm(byArray4, byArray3, byArray3.length, byArray2, this.sharedKey)) {
                return null;
            }
            byte[] byArray5 = new byte[byArray4.length - 16];
            for (int i = 0; i < byArray5.length; ++i) {
                byArray5[i] = byArray4[i + 16];
            }
            return byArray5;
        }

        public byte[] open_after(byte[] byArray) {
            return this.open_after(byArray, this.generateNonce());
        }

        public byte[] open_after(byte[] byArray, byte[] byArray2) {
            if (byArray == null || byArray.length <= 16 || byArray2 == null || byArray2.length != 24) {
                return null;
            }
            byte[] byArray3 = new byte[byArray.length + 16];
            byte[] byArray4 = new byte[byArray3.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray3[i + 16] = byArray[i];
            }
            if (TweetNacl.crypto_box_open_afternm(byArray4, byArray3, byArray3.length, byArray2, this.sharedKey) != 0) {
                return null;
            }
            byte[] byArray5 = new byte[byArray4.length - 32];
            for (int i = 0; i < byArray5.length; ++i) {
                byArray5[i] = byArray4[i + 32];
            }
            return byArray5;
        }

        public static KeyPair keyPair() {
            KeyPair keyPair = new KeyPair();
            TweetNacl.crypto_box_keypair(keyPair.getPublicKey(), keyPair.getSecretKey());
            return keyPair;
        }

        public static KeyPair keyPair_fromSecretKey(byte[] byArray) {
            KeyPair keyPair = new KeyPair();
            byte[] byArray2 = keyPair.getSecretKey();
            byte[] byArray3 = keyPair.getPublicKey();
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = byArray[i];
            }
            TweetNacl.crypto_scalarmult_base(byArray3, byArray2);
            return keyPair;
        }

        public static class KeyPair {
            private byte[] publicKey = new byte[32];
            private byte[] secretKey = new byte[32];

            public byte[] getPublicKey() {
                return this.publicKey;
            }

            public byte[] getSecretKey() {
                return this.secretKey;
            }
        }
    }
}

