/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ValueType {
    URI,
    URI_LONG,
    BNODE,
    SIMPLE,
    SIMPLE_LONG,
    TYPED,
    TYPED_LONG,
    NUMERIC,
    DATETIME,
    DATETIME_ZONED,
    LANG,
    LANG_LONG,
    XML,
    B14,
    B15,
    B16;

    private int index;

    public int index() {
        return this.index;
    }

    public boolean isBNode() {
        return BNODE.equals((Object)this);
    }

    public boolean isURI() {
        return URI.equals((Object)this) || URI_LONG.equals((Object)this);
    }

    public boolean isLiteral() {
        return !BNODE.equals((Object)this) && !URI.equals((Object)this) && !URI_LONG.equals((Object)this);
    }

    public boolean isSimpleLiteral() {
        return SIMPLE.equals((Object)this) || SIMPLE_LONG.equals((Object)this);
    }

    public boolean isLanguageLiteral() {
        return LANG.equals((Object)this) || LANG_LONG.equals((Object)this);
    }

    public boolean isTypedLiteral() {
        return this.isLiteral() && !this.isSimpleLiteral() && !this.isLanguageLiteral();
    }

    public boolean isNumericLiteral() {
        return NUMERIC.equals((Object)this);
    }

    public boolean isCalendarLiteral() {
        return DATETIME.equals((Object)this) || DATETIME_ZONED.equals((Object)this);
    }

    public boolean isLong() {
        return URI_LONG.equals((Object)this) || SIMPLE_LONG.equals((Object)this) || LANG_LONG.equals((Object)this) || TYPED_LONG.equals((Object)this) || XML.equals((Object)this);
    }

    static {
        for (ValueType type : ValueType.values()) {
            type.index = Arrays.asList(ValueType.values()).indexOf((Object)type);
        }
    }
}

