/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.datastore;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class IDFile {
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 105, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final long HEADER_LENGTH = 8L;
    private static final long ITEM_SIZE = 8L;
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final boolean forceSync;

    public IDFile(File file) throws IOException {
        this(file, false);
    }

    public IDFile(File file, boolean forceSync) throws IOException {
        boolean created;
        this.file = file;
        this.forceSync = forceSync;
        if (!file.exists() && !(created = file.createNewFile())) {
            throw new IOException("Failed to create file: " + file);
        }
        this.raf = new RandomAccessFile(file, "rw");
        this.fileChannel = this.raf.getChannel();
        if (this.fileChannel.size() == 0L) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.put(MAGIC_NUMBER);
            buf.put((byte)1);
            buf.put(new byte[]{0, 0, 0, 0});
            buf.rewind();
            this.fileChannel.write(buf, 0L);
            this.sync();
        } else {
            ByteBuffer buf = ByteBuffer.allocate(8);
            this.fileChannel.read(buf, 0L);
            buf.rewind();
            if ((long)buf.remaining() < 8L) {
                throw new IOException("File too short to be a compatible ID file");
            }
            byte[] magicNumber = new byte[MAGIC_NUMBER.length];
            buf.get(magicNumber);
            byte version = buf.get();
            if (!Arrays.equals(MAGIC_NUMBER, magicNumber)) {
                throw new IOException("File doesn't contain compatible ID records");
            }
            if (version > 1) {
                throw new IOException("Unable to read ID file; it uses a newer file format");
            }
            if (version != 1) {
                throw new IOException("Unable to read ID file; invalid file format version: " + version);
            }
        }
    }

    public final File getFile() {
        return this.file;
    }

    public int getMaxID() throws IOException {
        return (int)(this.fileChannel.size() / 8L) - 1;
    }

    public int storeOffset(long offset) throws IOException {
        int id = (int)(this.fileChannel.size() / 8L);
        this.setOffset(id, offset);
        return id;
    }

    public void setOffset(int id, long offset) throws IOException {
        assert (id > 0) : "id must be larger than 0, is: " + id;
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(0, offset);
        this.fileChannel.write(buf, 8L * (long)id);
    }

    public long getOffset(int id) throws IOException {
        assert (id > 0) : "id must be larger than 0, is: " + id;
        ByteBuffer buf = ByteBuffer.allocate(8);
        this.fileChannel.read(buf, 8L * (long)id);
        return buf.getLong(0);
    }

    public void clear() throws IOException {
        this.fileChannel.truncate(8L);
    }

    public void sync() throws IOException {
        if (this.forceSync) {
            this.fileChannel.force(false);
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

