/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.datastore;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class DataFile {
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 100, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final long HEADER_LENGTH = MAGIC_NUMBER.length + 1;
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final boolean forceSync;

    public DataFile(File file) throws IOException {
        this(file, false);
    }

    public DataFile(File file, boolean forceSync) throws IOException {
        boolean created;
        this.file = file;
        this.forceSync = forceSync;
        if (!file.exists() && !(created = file.createNewFile())) {
            throw new IOException("Failed to create file: " + file);
        }
        this.raf = new RandomAccessFile(file, "rw");
        this.fileChannel = this.raf.getChannel();
        if (this.fileChannel.size() == 0L) {
            ByteBuffer buf = ByteBuffer.allocate((int)HEADER_LENGTH);
            buf.put(MAGIC_NUMBER);
            buf.put((byte)1);
            buf.rewind();
            this.fileChannel.write(buf, 0L);
            this.sync();
        } else {
            ByteBuffer buf = ByteBuffer.allocate((int)HEADER_LENGTH);
            this.fileChannel.read(buf, 0L);
            buf.rewind();
            if ((long)buf.remaining() < HEADER_LENGTH) {
                throw new IOException("File too short to be a compatible data file");
            }
            byte[] magicNumber = new byte[MAGIC_NUMBER.length];
            buf.get(magicNumber);
            byte version = buf.get();
            if (!Arrays.equals(MAGIC_NUMBER, magicNumber)) {
                throw new IOException("File doesn't contain compatible data records");
            }
            if (version > 1) {
                throw new IOException("Unable to read data file; it uses a newer file format");
            }
            if (version != 1) {
                throw new IOException("Unable to read data file; invalid file format version: " + version);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public long storeData(byte[] data) throws IOException {
        assert (data != null) : "data must not be null";
        long offset = this.fileChannel.size();
        ByteBuffer buf = ByteBuffer.allocate(data.length + 4);
        buf.putInt(data.length);
        buf.put(data);
        buf.rewind();
        this.fileChannel.write(buf, offset);
        return offset;
    }

    public byte[] getData(long offset) throws IOException {
        assert (offset > 0L) : "offset must be larger than 0, is: " + offset;
        ByteBuffer buf = ByteBuffer.allocate(4);
        this.fileChannel.read(buf, offset);
        int dataLength = buf.getInt(0);
        byte[] data = new byte[dataLength];
        buf = ByteBuffer.wrap(data);
        this.fileChannel.read(buf, offset + 4L);
        return data;
    }

    public void clear() throws IOException {
        this.fileChannel.truncate(HEADER_LENGTH);
    }

    public void sync() throws IOException {
        if (this.forceSync) {
            this.fileChannel.force(false);
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public DataIterator iterator() {
        return new DataIterator();
    }

    static /* synthetic */ long access$000() {
        return HEADER_LENGTH;
    }

    public class DataIterator {
        private long position = DataFile.access$000();

        public boolean hasNext() throws IOException {
            return this.position < DataFile.this.fileChannel.size();
        }

        public byte[] next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] data = DataFile.this.getData(this.position);
            this.position += (long)(4 + data.length);
            return data;
        }
    }
}

