/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import org.openrdf.sail.nativerdf.RecordCache;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

final class SequentialRecordCache
extends RecordCache {
    private static final byte[] MAGIC_NUMBER = new byte[]{115, 114, 99};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final int HEADER_LENGTH = MAGIC_NUMBER.length + 1;
    private final File cacheFile;
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final int recordSize;

    public SequentialRecordCache(File cacheDir, int recordSize) throws IOException {
        this(cacheDir, recordSize, Long.MAX_VALUE);
    }

    public SequentialRecordCache(File cacheDir, int recordSize, long maxRecords) throws IOException {
        super(maxRecords);
        this.recordSize = recordSize;
        this.cacheFile = File.createTempFile("txncache", ".dat", cacheDir);
        this.raf = new RandomAccessFile(this.cacheFile, "rw");
        this.fileChannel = this.raf.getChannel();
        this.raf.write(MAGIC_NUMBER);
        this.raf.write(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() throws IOException {
        try {
            try {
                this.fileChannel.close();
            }
            finally {
                this.raf.close();
            }
        }
        finally {
            this.cacheFile.delete();
        }
    }

    protected void clearInternal() throws IOException {
        this.fileChannel.truncate(HEADER_LENGTH);
    }

    protected void storeRecordInternal(byte[] data) throws IOException {
        this.fileChannel.write(ByteBuffer.wrap(data), this.fileChannel.size());
    }

    protected RecordIterator getRecordsInternal() {
        return new RecordCacheIterator();
    }

    protected class RecordCacheIterator
    implements RecordIterator {
        private long position = SequentialRecordCache.access$000();

        protected RecordCacheIterator() {
        }

        public byte[] next() throws IOException {
            if (this.position + (long)SequentialRecordCache.this.recordSize <= SequentialRecordCache.this.fileChannel.size()) {
                byte[] data = new byte[SequentialRecordCache.this.recordSize];
                ByteBuffer buf = ByteBuffer.wrap(data);
                int bytesRead = SequentialRecordCache.this.fileChannel.read(buf, this.position);
                if (bytesRead < 0) {
                    throw new NoSuchElementException("No more elements available");
                }
                this.position += (long)bytesRead;
                return data;
            }
            return null;
        }

        public void set(byte[] value) throws IOException {
            if (this.position >= (long)(HEADER_LENGTH + SequentialRecordCache.this.recordSize) && this.position <= SequentialRecordCache.this.fileChannel.size()) {
                SequentialRecordCache.this.fileChannel.write(ByteBuffer.wrap(value), this.position - (long)SequentialRecordCache.this.recordSize);
            }
        }

        public void close() throws IOException {
        }
    }
}

