/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser;

import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.QueryParserFactory;
import org.openrdf.query.parser.QueryParserRegistry;

public class QueryParserUtil {
    public static QueryParser createParser(QueryLanguage ql) throws UnsupportedQueryLanguageException {
        QueryParserFactory factory = (QueryParserFactory)QueryParserRegistry.getInstance().get(ql);
        if (factory != null) {
            return factory.getParser();
        }
        throw new UnsupportedQueryLanguageException("No factory available for query language " + ql);
    }

    public static ParsedQuery parseQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        QueryParser parser = QueryParserUtil.createParser(ql);
        return parser.parseQuery(query, baseURI);
    }

    public static ParsedTupleQuery parseTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedTupleQuery) {
            return (ParsedTupleQuery)q;
        }
        throw new IllegalArgumentException("query is not a tuple query: " + query);
    }

    public static ParsedGraphQuery parseGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedGraphQuery) {
            return (ParsedGraphQuery)q;
        }
        throw new IllegalArgumentException("query is not a graph query: " + query);
    }

    public static ParsedBooleanQuery parseBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedBooleanQuery) {
            return (ParsedBooleanQuery)q;
        }
        throw new IllegalArgumentException("query is not a boolean query: " + query);
    }
}

