/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slice
extends UnaryTupleOperator {
    private int offset;
    private int limit;

    public Slice() {
    }

    public Slice(TupleExpr arg) {
        this(arg, 0, -1);
    }

    public Slice(TupleExpr arg, int offset, int limit) {
        super(arg);
        this.setOffset(offset);
        this.setLimit(limit);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean hasOffset() {
        return this.offset > 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean hasLimit() {
        return this.limit >= 0;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(super.getSignature());
        sb.append(" ( ");
        if (this.hasLimit()) {
            sb.append("limit=").append(this.getLimit());
        }
        if (this.hasOffset()) {
            sb.append("offset=").append(this.getOffset());
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Slice && super.equals(other)) {
            Slice o = (Slice)other;
            return this.offset == o.getOffset() && this.limit == o.getLimit();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.limit;
    }

    @Override
    public Slice clone() {
        return (Slice)super.clone();
    }
}

