/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.webapp.util;

import info.aduna.webapp.util.FilePart;
import info.aduna.webapp.util.HeaderElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerUtil {
    private static final String _UNKNOWN = "__UNKNOWN__";

    public static String getMIMEType(String contentType) {
        if (contentType == null) {
            return null;
        }
        return HeaderElement.parse(contentType).getValue();
    }

    public static String[] getPathSegments(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return new String[0];
        }
        assert (pathInfo.charAt(0) == '/');
        String[] segments = pathInfo.substring(1).split("/");
        return segments;
    }

    public static String getLastPathSegment(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        int slashIdx = pathInfo.lastIndexOf(47);
        assert (slashIdx >= 0);
        return pathInfo.substring(slashIdx + 1);
    }

    public static String selectPreferredMIMEType(Iterator<String> mimeTypes, HttpServletRequest request) {
        List<HeaderElement> acceptElements = HttpServerUtil.getHeaderElements(request, "Accept");
        if (acceptElements.isEmpty()) {
            if (mimeTypes.hasNext()) {
                return mimeTypes.next();
            }
            return null;
        }
        String result = null;
        double highestQuality = 0.0;
        while (mimeTypes.hasNext()) {
            String mimeType = mimeTypes.next();
            HeaderElement acceptType = HttpServerUtil.matchAcceptHeader(mimeType, acceptElements);
            if (acceptType == null) continue;
            double quality = 1.0;
            String qualityStr = acceptType.getParameterValue("q");
            if (qualityStr != null) {
                try {
                    quality = Double.parseDouble(qualityStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (!(quality > highestQuality)) continue;
            result = mimeType;
            highestQuality = quality;
        }
        return result;
    }

    public static List<HeaderElement> getHeaderElements(HttpServletRequest request, String headerName) {
        ArrayList<HeaderElement> elemList = new ArrayList<HeaderElement>(8);
        Enumeration headerValues = request.getHeaders(headerName);
        while (headerValues.hasMoreElements()) {
            String value = (String)headerValues.nextElement();
            List<String> subValues = HttpServerUtil.splitHeaderString(value, ',');
            for (String subValue : subValues) {
                if ((subValue = subValue.trim()).length() <= 0) continue;
                elemList.add(HeaderElement.parse(subValue));
            }
        }
        return elemList;
    }

    public static List<String> splitHeaderString(String s, char splitChar) {
        ArrayList<String> result = new ArrayList<String>(8);
        boolean parsingQuotedString = false;
        int startIdx = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == splitChar && !parsingQuotedString) {
                result.add(s.substring(startIdx, i));
                startIdx = i + 1;
                continue;
            }
            if (c != '\"') continue;
            parsingQuotedString = !parsingQuotedString;
        }
        if (startIdx < s.length()) {
            result.add(s.substring(startIdx));
        }
        return result;
    }

    public static HeaderElement matchAcceptHeader(String mimeTypeSpec, List<HeaderElement> acceptElements) {
        HeaderElement mimeTypeElem = HeaderElement.parse(mimeTypeSpec);
        while (mimeTypeElem != null) {
            for (HeaderElement acceptElem : acceptElements) {
                if (!HttpServerUtil.matchesAcceptHeader(mimeTypeElem, acceptElem)) continue;
                return acceptElem;
            }
            mimeTypeElem = HttpServerUtil.generalizeMIMEType(mimeTypeElem);
        }
        return null;
    }

    private static boolean matchesAcceptHeader(HeaderElement mimeTypeElem, HeaderElement acceptElem) {
        if (!mimeTypeElem.getValue().equals(acceptElem.getValue())) {
            return false;
        }
        if (mimeTypeElem.getParameterCount() > acceptElem.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < mimeTypeElem.getParameterCount(); ++i) {
            if (mimeTypeElem.getParameter(i).equals(acceptElem.getParameter(i))) continue;
            return false;
        }
        return true;
    }

    private static HeaderElement generalizeMIMEType(HeaderElement mimeTypeElem) {
        int parameterCount = mimeTypeElem.getParameterCount();
        if (parameterCount > 0) {
            mimeTypeElem.removeParameter(parameterCount - 1);
        } else {
            String mimeType = mimeTypeElem.getValue();
            int slashIdx = mimeType.indexOf(47);
            if (slashIdx > 0) {
                String type = mimeType.substring(0, slashIdx);
                String subType = mimeType.substring(slashIdx + 1);
                if (!subType.equals("*")) {
                    mimeTypeElem.setValue(type + "/*");
                } else if (!type.equals("*")) {
                    mimeTypeElem.setValue("*/*");
                } else {
                    mimeTypeElem = null;
                }
            } else {
                mimeTypeElem = null;
            }
        }
        return mimeTypeElem;
    }

    public static String getPostDataParameter(Map<String, Object> formData, String name) {
        String result = null;
        try {
            Object param = formData.get(name);
            if (param instanceof String[]) {
                String[] paramArray = (String[])param;
                if (paramArray.length > 0) {
                    result = paramArray[0];
                }
            } else if (param instanceof String) {
                result = (String)param;
            }
            if (result != null) {
                result = result.trim();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    public static Map<String, Object> getPostData(HttpServletRequest request) {
        Map<String, Object> result = null;
        String contentType = request.getContentType();
        result = contentType != null && contentType.startsWith("multipart/form-data") ? HttpServerUtil.parseMultipartFormData(request) : request.getParameterMap();
        return result;
    }

    public static Map<String, Object> parseMultipartFormData(HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int contentLength = request.getContentLength();
        String contentType = request.getContentType();
        byte[] formData = new byte[]{};
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (contentLength < 0) {
                contentLength = 102400;
            }
            formData = new byte[contentLength];
            contentLength = inputStream.read(formData);
            inputStream.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (contentType != null) {
            int boundaryPos = contentType.indexOf("boundary=") + "boundary=".length();
            String boundaryString = "--" + contentType.substring(boundaryPos);
            byte[] boundary = boundaryString.trim().getBytes();
            int boundaryLength = boundary.length;
            ArrayList<byte[]> parts = new ArrayList<byte[]>();
            int partStart = 0;
            int partEnd = 0;
            boolean firstBoundary = true;
            while ((boundaryPos = HttpServerUtil.findIndexOf(boundary, formData, partStart)) != -1) {
                if (firstBoundary) {
                    firstBoundary = false;
                } else {
                    partEnd = boundaryPos;
                    byte[] part = new byte[partEnd - partStart];
                    System.arraycopy(formData, partStart, part, 0, partEnd - partStart);
                    part = HttpServerUtil.trimReturns(part);
                    parts.add(part);
                }
                partStart = boundaryPos + boundaryLength;
            }
            for (int i = 0; i < parts.size(); ++i) {
                int bodyStart;
                byte[] part = (byte[])parts.get(i);
                String name = null;
                String filename = null;
                String fileContentType = null;
                name = HttpServerUtil.findAttribute("name=\"", "\"", part).trim();
                filename = HttpServerUtil.findAttribute("filename=\"", "\"", part).trim();
                if (!filename.equals(_UNKNOWN)) {
                    int slashPos = filename.lastIndexOf("/");
                    int backslashPos = filename.lastIndexOf("\\");
                    if (slashPos >= 0 || backslashPos >= 0) {
                        int lastPos = Math.max(slashPos, backslashPos);
                        filename = filename.substring(lastPos + 1);
                    }
                    fileContentType = (fileContentType = HttpServerUtil.findAttribute("Content-Type: ", "\n", part)) == null ? _UNKNOWN : fileContentType.trim();
                }
                int bodyStartCR = HttpServerUtil.findIndexOf("\n\n".getBytes(), part, 0);
                int bodyStartCRLF = HttpServerUtil.findIndexOf("\r\n\r\n".getBytes(), part, 0);
                byte[] bodyArray = null;
                if (bodyStartCR < 0 && bodyStartCRLF < 0) {
                    bodyArray = new byte[]{};
                    bodyStart = -1;
                } else {
                    bodyStart = bodyStartCR < 0 ? bodyStartCRLF : (bodyStartCRLF < 0 ? bodyStartCR : Math.min(bodyStartCR, bodyStartCRLF));
                }
                if (bodyStart >= 0) {
                    int bodyEnd = part.length;
                    bodyStart = bodyStart == bodyStartCR ? (bodyStart += "\n\n".getBytes().length) : (bodyStart += "\r\n\r\n".getBytes().length);
                    bodyArray = new byte[bodyEnd - bodyStart];
                    System.arraycopy(part, bodyStart, bodyArray, 0, bodyEnd - bodyStart);
                }
                if (!filename.equals(_UNKNOWN)) {
                    result.put(name, new FilePart(filename, fileContentType, bodyArray));
                    continue;
                }
                result.put(name, new String(bodyArray));
            }
        }
        return result;
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Cache-Control", "max-age=1");
        response.setHeader("Cache-Control", "no-cache");
        response.setIntHeader("Expires", 0);
        response.setHeader("Pragma", "no-cache");
    }

    private static int findIndexOf(byte[] toFind, byte[] source, int offset) {
        int toFindLength = toFind.length;
        int maxI = source.length - toFindLength;
        for (int i = offset; i <= maxI; ++i) {
            int j;
            for (j = 0; j < toFindLength && toFind[j] == source[i + j]; ++j) {
            }
            if (j != toFindLength) continue;
            return i;
        }
        return -1;
    }

    private static String findAttribute(String startPattern, String endPattern, byte[] sourceArray) {
        int indexOfEndPattern;
        String result = null;
        String source = new String(sourceArray);
        int indexOfStartPattern = source.indexOf(startPattern);
        result = indexOfStartPattern < 0 ? _UNKNOWN : ((indexOfEndPattern = source.indexOf(endPattern, indexOfStartPattern + startPattern.length())) < 0 ? _UNKNOWN : source.substring(indexOfStartPattern + startPattern.length(), indexOfEndPattern));
        return result;
    }

    private static byte[] trimReturns(byte[] source) {
        byte[] result = source;
        int srcLength = source.length;
        int resultStart = 0;
        int resultLength = source.length;
        if (resultLength >= 2 && source[0] == 13 && source[1] == 10) {
            resultStart = 2;
            resultLength -= 2;
        } else if (resultLength >= 1 && source[0] == 10) {
            resultStart = 1;
            --resultLength;
        }
        if (resultLength >= 2 && source[srcLength - 2] == 13 && source[srcLength - 1] == 10) {
            resultLength -= 2;
        } else if (resultLength >= 1 && source[srcLength - 1] == 10) {
            --resultLength;
        }
        if (resultLength != srcLength) {
            result = new byte[resultLength];
            System.arraycopy(source, resultStart, result, 0, resultLength);
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        boolean result = false;
        if (string == null || string.trim().equals("")) {
            result = true;
        }
        return result;
    }

    public static boolean isTrue(String string) {
        boolean result = false;
        if (!HttpServerUtil.isEmpty(string) && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on"))) {
            result = true;
        }
        return result;
    }

    public static boolean isFalse(String string) {
        boolean result = false;
        if (!HttpServerUtil.isEmpty(string) && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off"))) {
            result = true;
        }
        return result;
    }
}

