/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.io;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;

public class PushbackReader
extends Reader {
    private Stack<Reader> readerStack = new Stack();

    public PushbackReader() {
    }

    public PushbackReader(Reader r) {
        this();
        this.pushback(r);
    }

    public void pushback(Reader r) {
        this.readerStack.push(r);
    }

    public void pushback(String s) {
        this.pushback(new StringReader(s));
    }

    public void pushback(char[] chars) {
        this.pushback(new CharArrayReader(chars));
    }

    public void pushback(char[] chars, int off, int len) {
        this.pushback(new CharArrayReader(chars, off, len));
    }

    public int read() throws IOException {
        int c = -1;
        while (c == -1 && !this.readerStack.empty()) {
            Reader r = this.readerStack.peek();
            c = r.read();
            if (c != -1) continue;
            this.readerStack.pop();
        }
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int readSoFar = 0;
        while (readSoFar < len && !this.readerStack.empty()) {
            Reader r = this.readerStack.peek();
            int nofChars = r.read(cbuf, off + readSoFar, len - readSoFar);
            if (nofChars == -1) {
                this.readerStack.pop();
                continue;
            }
            readSoFar += nofChars;
        }
        if (readSoFar == 0 && this.readerStack.empty()) {
            return -1;
        }
        return readSoFar;
    }

    public void close() throws IOException {
        while (!this.readerStack.empty()) {
            Reader r = this.readerStack.pop();
            r.close();
        }
    }
}

