/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections.iterators;

import info.aduna.collections.iterators.EmptyIterator;
import info.aduna.collections.iterators.Iterators;
import info.aduna.collections.iterators.LookAheadIterator;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionIterator<E>
extends LookAheadIterator<E> {
    private final Iterator<? extends Iterator<? extends E>> argIter;
    private Iterator<? extends E> currentIter;

    public UnionIterator(Iterator<? extends E> ... args) {
        this(Arrays.asList(args));
    }

    public UnionIterator(Iterable<? extends Iterator<? extends E>> args) {
        this.argIter = args.iterator();
        this.currentIter = new EmptyIterator<E>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected E getNextElement() {
        if (this.currentIter.hasNext()) {
            return this.currentIter.next();
        }
        Iterators.closeCloseable(this.currentIter);
        UnionIterator unionIterator = this;
        synchronized (unionIterator) {
            if (this.argIter.hasNext()) {
                this.currentIter = this.argIter.next();
                return this.getNextElement();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() {
        super.handleClose();
        UnionIterator unionIterator = this;
        synchronized (unionIterator) {
            while (this.argIter.hasNext()) {
                Iterators.closeCloseable(this.argIter.next());
            }
        }
        Iterators.closeCloseable(this.currentIter);
    }
}

