/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.concurrent.locks.Lock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.openrdf.sail.LockManager;
import org.openrdf.sail.SailLockedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryLockManager
implements LockManager {
    private Logger logger = LoggerFactory.getLogger(DirectoryLockManager.class);
    private File dir;

    public DirectoryLockManager(File dir) {
        this.dir = dir;
    }

    public boolean isLocked() {
        return new File(this.dir, "lock").exists();
    }

    public Lock tryLock() {
        File lockDir = new File(this.dir, "lock");
        if (lockDir.exists() || !lockDir.mkdir()) {
            return null;
        }
        File lockFile = new File(lockDir, "process");
        Lock lock = this.createLock(lockDir, lockFile);
        try {
            this.sign(lockFile);
        }
        catch (IOException exc) {
            lock.release();
            this.logger.error(exc.toString(), (Throwable)exc);
            return null;
        }
        return lock;
    }

    public Lock lockOrFail() throws SailLockedException {
        Lock lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        String requestedBy = this.getProcessName();
        String lockedBy = this.getLockedBy();
        if (lockedBy != null) {
            throw new SailLockedException(lockedBy, requestedBy, this);
        }
        lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        throw new SailLockedException(requestedBy);
    }

    public boolean revokeLock() {
        File lockDir = new File(this.dir, "lock");
        File lockFile = new File(lockDir, "process");
        return lockFile.delete() && lockDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockedBy() {
        String string;
        File lockDir = new File(this.dir, "lock");
        File lockFile = new File(lockDir, "process");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(lockFile));
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException exc) {
                this.logger.warn(exc.toString(), (Throwable)exc);
                return null;
            }
        }
        reader.close();
        return string;
    }

    private Lock createLock(final File lockDir, final File lockFile) {
        return new Lock(){
            private boolean active = true;
            private Thread hook = new Thread(new Runnable(){

                public void run() {
                    active = false;
                    lockFile.delete();
                    lockDir.delete();
                }
            });
            {
                Runtime.getRuntime().addShutdownHook(this.hook);
            }

            public boolean isActive() {
                return this.active;
            }

            public void release() {
                this.active = false;
                Runtime.getRuntime().removeShutdownHook(this.hook);
                lockFile.delete();
                lockDir.delete();
            }
        };
    }

    private void sign(File lockFile) throws IOException {
        FileWriter out = new FileWriter(lockFile);
        out.write(this.getProcessName());
        out.flush();
        out.close();
    }

    private String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }
}

