/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.contextaware;

import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionWrapper;
import org.openrdf.repository.util.RDFInserter;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextAwareConnection
extends RepositoryConnectionWrapper {
    private static final URI[] ALL_CONTEXTS = new URI[0];
    private boolean includeInferred = true;
    private int maxQueryTime;
    private QueryLanguage ql = QueryLanguage.SPARQL;
    private URI[] readContexts = ALL_CONTEXTS;
    private URI[] addContexts = ALL_CONTEXTS;
    private URI[] removeContexts = ALL_CONTEXTS;
    private URI[] archiveContexts = ALL_CONTEXTS;

    public ContextAwareConnection(Repository repository) throws RepositoryException {
        this(repository, repository.getConnection());
    }

    public ContextAwareConnection(Repository repository, RepositoryConnection connection) {
        super(repository, connection);
    }

    @Override
    protected boolean isDelegatingRemove() {
        return this.archiveContexts.length == 0;
    }

    public boolean isIncludeInferred() {
        return this.includeInferred;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public int getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
    }

    public QueryLanguage getQueryLanguage() {
        return this.ql;
    }

    public void setQueryLanguage(QueryLanguage ql) {
        this.ql = ql;
    }

    public URI[] getReadContexts() {
        return this.readContexts;
    }

    public void setReadContexts(URI ... readContexts) {
        this.readContexts = readContexts;
    }

    public URI[] getAddContexts() {
        return this.addContexts;
    }

    public void setAddContexts(URI ... addContexts) {
        this.addContexts = addContexts;
    }

    public URI[] getRemoveContexts() {
        return this.removeContexts;
    }

    public void setRemoveContexts(URI ... removeContexts) {
        this.removeContexts = removeContexts;
    }

    public URI[] getArchiveContexts() {
        return this.archiveContexts;
    }

    public void setArchiveContexts(URI ... archiveContexts) {
        this.archiveContexts = archiveContexts;
    }

    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.add(file, baseURI, dataFormat, (Resource[])this.addContexts);
        } else {
            super.add(file, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.add(in, baseURI, dataFormat, (Resource[])this.addContexts);
        } else {
            super.add(in, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.add(statements, (Resource[])this.addContexts);
        } else {
            super.add(statements, contexts);
        }
    }

    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        if (contexts == null || contexts.length < 1) {
            super.add(statementIter, (Resource[])this.addContexts);
        } else {
            super.add(statementIter, contexts);
        }
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.add(reader, baseURI, dataFormat, (Resource[])this.addContexts);
        } else {
            super.add(reader, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.add(subject, predicate, object, (Resource[])this.addContexts);
        } else {
            super.add(subject, predicate, object, contexts);
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.add(st, (Resource[])this.addContexts);
        } else {
            super.add(st, contexts);
        }
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.add(url, baseURI, dataFormat, (Resource[])this.addContexts);
        } else {
            super.add(url, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.clear(this.removeContexts);
        } else {
            super.clear(contexts);
        }
    }

    @Override
    public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        if (contexts == null || contexts.length < 1) {
            super.export(handler, this.readContexts);
        } else {
            super.export(handler, contexts);
        }
    }

    public void exportStatements(Resource subj, URI pred, Value obj, RDFHandler hander, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        if (contexts == null || contexts.length < 1) {
            super.exportStatements(subj, pred, obj, this.includeInferred, hander, this.readContexts);
        } else {
            super.exportStatements(subj, pred, obj, this.includeInferred, hander, contexts);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            return super.getStatements(subj, pred, obj, this.includeInferred, this.readContexts);
        }
        return super.getStatements(subj, pred, obj, this.includeInferred, contexts);
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            return super.hasStatement(subj, pred, obj, this.includeInferred, (Resource[])this.readContexts);
        }
        return super.hasStatement(subj, pred, obj, this.includeInferred, contexts);
    }

    public boolean hasStatement(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            return super.hasStatement(st, this.includeInferred, this.readContexts);
        }
        return super.hasStatement(st, this.includeInferred, contexts);
    }

    public GraphQuery prepareGraphQuery(String query) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareGraphQuery(this.ql, query));
    }

    public Query prepareQuery(String query) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareQuery(this.ql, query));
    }

    public TupleQuery prepareTupleQuery(String query) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareTupleQuery(this.ql, query));
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareGraphQuery(ql, query));
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareQuery(ql, query));
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareTupleQuery(ql, query));
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareBooleanQuery(ql, query));
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareGraphQuery(ql, query, baseURI));
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareQuery(ql, query, baseURI));
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareTupleQuery(ql, query, baseURI));
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.initQuery(super.prepareBooleanQuery(ql, query, baseURI));
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.remove(statements, (Resource[])this.removeContexts);
        } else {
            super.remove(statements, contexts);
        }
    }

    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        if (contexts == null || contexts.length < 1) {
            super.remove(statementIter, (Resource[])this.removeContexts);
        } else {
            super.remove(statementIter, contexts);
        }
    }

    @Override
    public void remove(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.remove(subject, predicate, object, (Resource[])this.removeContexts);
        } else {
            super.remove(subject, predicate, object, contexts);
        }
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            super.remove(st, (Resource[])this.removeContexts);
        } else {
            super.remove(st, contexts);
        }
    }

    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        if (contexts == null || contexts.length < 1) {
            return super.size(this.readContexts);
        }
        return super.size(contexts);
    }

    @Override
    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        RDFInserter handler = new RDFInserter(this.getDelegate());
        try {
            this.getDelegate().exportStatements(subject, predicate, object, true, handler, this.archiveContexts);
        }
        catch (RDFHandlerException e) {
            if (e.getCause() instanceof RepositoryException) {
                throw (RepositoryException)e.getCause();
            }
            throw new AssertionError((Object)e);
        }
        this.getDelegate().remove(subject, predicate, object, contexts);
    }

    private <Q extends Query> Q initQuery(Q query) {
        if (this.readContexts.length > 0) {
            DatasetImpl ds = new DatasetImpl();
            for (URI graph : this.readContexts) {
                ds.addDefaultGraph(graph);
            }
            query.setDataset(ds);
        }
        query.setIncludeInferred(this.includeInferred);
        query.setMaxQueryTime(this.maxQueryTime);
        return query;
    }
}

