/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIterationBase;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.evaluation.iterator.ProjectionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiProjectionIterator
extends CloseableIterationBase<BindingSet, QueryEvaluationException> {
    private final List<ProjectionElemList> projections;
    private final Iteration<BindingSet, QueryEvaluationException> iter;
    private final BindingSet parentBindings;
    private BindingSet currentBindings;
    private int nextProjectionIdx;

    public MultiProjectionIterator(MultiProjection multiProjection, CloseableIteration<BindingSet, QueryEvaluationException> iter, BindingSet bindings) {
        this.projections = multiProjection.getProjections();
        this.iter = iter;
        this.parentBindings = bindings;
        this.nextProjectionIdx = this.projections.size();
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        return this.nextProjectionIdx < this.projections.size() || this.iter.hasNext();
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (this.nextProjectionIdx >= this.projections.size()) {
            this.currentBindings = this.iter.next();
            this.nextProjectionIdx = 0;
        }
        ProjectionElemList nextProjection = this.projections.get(this.nextProjectionIdx++);
        return ProjectionIterator.project(nextProjection, this.currentBindings, this.parentBindings);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        Iterations.closeCloseable(this.iter);
        this.nextProjectionIdx = this.projections.size();
    }
}

