/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class DisjunctiveConstraintOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new OrSameTermOptimizer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OrSameTermOptimizer
    extends QueryModelVisitorBase<RuntimeException> {
        protected OrSameTermOptimizer() {
        }

        @Override
        public void meet(Or orNode) {
            boolean top = orNode.getParentNode() instanceof Filter;
            if (top && this.containsSameTerm(orNode)) {
                Filter filter = (Filter)orNode.getParentNode();
                ValueExpr left = orNode.getLeftArg().clone();
                ValueExpr right = orNode.getRightArg().clone();
                filter.replaceWith(filter.getArg());
                TupleExpr node = this.findNotFilter(filter.getArg());
                Filter leftFilter = new Filter(node.clone(), left);
                Filter rightFilter = new Filter(node.clone(), right);
                Union union = new Union(leftFilter, rightFilter);
                node.replaceWith(union);
                filter.getParentNode().visit(this);
            } else {
                super.meet(orNode);
            }
        }

        private TupleExpr findNotFilter(TupleExpr node) {
            if (node instanceof Filter) {
                return this.findNotFilter(((Filter)node).getArg());
            }
            return node;
        }

        private boolean containsSameTerm(ValueExpr node) {
            if (node instanceof SameTerm) {
                return true;
            }
            if (node instanceof Or) {
                Or or = (Or)node;
                boolean left = this.containsSameTerm(or.getLeftArg());
                return left || this.containsSameTerm(or.getRightArg());
            }
            if (node instanceof And) {
                And and = (And)node;
                boolean left = this.containsSameTerm(and.getLeftArg());
                return left || this.containsSameTerm(and.getRightArg());
            }
            return false;
        }
    }
}

