/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.lang;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFormat {
    private String name;
    private List<String> mimeTypes = new ArrayList<String>(1);
    private Charset charset;
    private List<String> fileExtensions = new ArrayList<String>(1);

    public FileFormat(String name, String mimeType, Charset charset, String fileExtension) {
        this(name, Arrays.asList(mimeType), charset, Arrays.asList(fileExtension));
    }

    public FileFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions) {
        this(name, Arrays.asList(mimeType), charset, fileExtensions);
    }

    public FileFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions) {
        assert (name != null) : "name must not be null";
        assert (mimeTypes != null) : "mimeTypes must not be null";
        assert (!mimeTypes.isEmpty()) : "mimeTypes must not be empty";
        assert (fileExtensions != null) : "fileExtensions must not be null";
        this.name = name;
        this.mimeTypes.addAll(mimeTypes);
        this.charset = charset;
        this.fileExtensions.addAll(fileExtensions);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultMIMEType() {
        return this.mimeTypes.get(0);
    }

    public boolean hasDefaultMIMEType(String mimeType) {
        return this.getDefaultMIMEType().equalsIgnoreCase(mimeType);
    }

    public List<String> getMIMETypes() {
        return Collections.unmodifiableList(this.mimeTypes);
    }

    public boolean hasMIMEType(String mimeType) {
        for (String mt : this.mimeTypes) {
            if (!mt.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultFileExtension() {
        if (this.fileExtensions.isEmpty()) {
            return null;
        }
        return this.fileExtensions.get(0);
    }

    public boolean hasDefaultFileExtension(String extension) {
        String ext = this.getDefaultFileExtension();
        return ext != null && ext.equalsIgnoreCase(extension);
    }

    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(this.mimeTypes);
    }

    public boolean hasFileExtension(String extension) {
        for (String ext : this.fileExtensions) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean hasCharset() {
        return this.charset != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FileFormat) {
            return this.name.equalsIgnoreCase(((FileFormat)other).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.toLowerCase(Locale.ENGLISH).hashCode();
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.name);
        sb.append(" (mimeTypes=");
        for (i = 0; i < this.mimeTypes.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.mimeTypes.get(i));
        }
        sb.append("; ext=");
        for (i = 0; i < this.fileExtensions.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.fileExtensions.get(i));
        }
        sb.append(")");
        return sb.toString();
    }

    public static <FF extends FileFormat> FF matchMIMEType(String mimeType, Iterable<FF> fileFormats) {
        return FileFormat.matchMIMEType(mimeType, fileFormats, null);
    }

    public static <FF extends FileFormat> FF matchMIMEType(String mimeType, Iterable<FF> fileFormats, FF fallback) {
        for (FileFormat fileFormat : fileFormats) {
            if (!fileFormat.hasDefaultMIMEType(mimeType)) continue;
            return (FF)fileFormat;
        }
        for (FileFormat fileFormat : fileFormats) {
            if (!fileFormat.hasMIMEType(mimeType)) continue;
            return (FF)fileFormat;
        }
        return fallback;
    }

    public static <FF extends FileFormat> FF matchFileName(String fileName, Iterable<FF> fileFormats) {
        return FileFormat.matchFileName(fileName, fileFormats, null);
    }

    public static <FF extends FileFormat> FF matchFileName(String fileName, Iterable<FF> fileFormats, FF fallback) {
        int dotIdx;
        int lastPathSepIdx = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92));
        if (lastPathSepIdx >= 0) {
            fileName = fileName.substring(lastPathSepIdx + 1);
        }
        while ((dotIdx = fileName.lastIndexOf(46)) >= 0) {
            String ext = fileName.substring(dotIdx + 1);
            for (FileFormat fileFormat : fileFormats) {
                if (!fileFormat.hasDefaultFileExtension(ext)) continue;
                return (FF)fileFormat;
            }
            for (FileFormat fileFormat : fileFormats) {
                if (!fileFormat.hasFileExtension(ext)) continue;
                return (FF)fileFormat;
            }
            fileName = fileName.substring(0, dotIdx);
        }
        return fallback;
    }
}

