/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.LookAheadIteration;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionIteration<E, X extends Exception>
extends LookAheadIteration<E, X> {
    private Iterator<? extends Iteration<? extends E, X>> argIter;
    private Iteration<? extends E, X> currentIter;

    public UnionIteration(Iteration<? extends E, X> ... args) {
        this(Arrays.asList(args));
    }

    public UnionIteration(Iterable<? extends Iteration<? extends E, X>> args) {
        this.argIter = args.iterator();
        this.currentIter = new EmptyIteration<E, X>();
    }

    @Override
    protected E getNextElement() throws X {
        if (this.currentIter.hasNext()) {
            return this.currentIter.next();
        }
        Iterations.closeCloseable(this.currentIter);
        if (this.argIter.hasNext()) {
            this.currentIter = this.argIter.next();
            return this.getNextElement();
        }
        return null;
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        while (this.argIter.hasNext()) {
            Iterations.closeCloseable(this.argIter.next());
        }
        Iterations.closeCloseable(this.currentIter);
    }
}

