/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeLimitIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Timer timer;
    private boolean isInterrupted = false;

    public TimeLimitIteration(Iteration<? extends E, ? extends X> iter, long timeLimit) {
        super(iter);
        assert (timeLimit > 0L) : "time limit must be a positive number, is: " + timeLimit;
        this.startTimer(timeLimit);
    }

    @Override
    public boolean hasNext() throws X {
        this.checkInterrupted();
        boolean result = super.hasNext();
        this.checkInterrupted();
        return result;
    }

    @Override
    public E next() throws X {
        this.checkInterrupted();
        try {
            return super.next();
        }
        catch (NoSuchElementException e) {
            this.checkInterrupted();
            throw e;
        }
    }

    @Override
    public void remove() throws X {
        this.checkInterrupted();
        super.remove();
    }

    @Override
    protected void handleClose() throws X {
        this.timer.cancel();
        super.handleClose();
    }

    private final void checkInterrupted() throws X {
        if (this.isInterrupted) {
            this.throwInterruptedException();
        }
    }

    protected abstract void throwInterruptedException() throws X;

    private void startTimer(long timeLimit) {
        TimerTask tt = new TimerTask(){

            public void run() {
                TimeLimitIteration.this.interrupt();
            }
        };
        this.timer = new Timer("TimeLimitIteration", true);
        this.timer.schedule(tt, timeLimit);
    }

    private void interrupt() {
        if (!this.isClosed()) {
            this.isInterrupted = true;
            try {
                this.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close iteration", (Throwable)e);
            }
        }
    }
}

