/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.JenaException;
import org.openrdf.repository.RepositoryException;

public class AGTransactionHandler
implements TransactionHandler {
    private final AGGraph graph;

    AGTransactionHandler(AGGraph graph) {
        this.graph = graph;
    }

    public void abort() {
        try {
            this.graph.getConnection().rollback();
            this.graph.getConnection().setAutoCommit(true);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void begin() {
        try {
            this.graph.getConnection().setAutoCommit(false);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void commit() {
        try {
            this.graph.getConnection().commit();
            this.graph.getConnection().setAutoCommit(true);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public Object executeInTransaction(Command c) {
        try {
            this.begin();
            c.execute();
            this.commit();
        }
        catch (Throwable e) {
            throw new JenaException(e);
        }
        return null;
    }

    public boolean transactionsSupported() {
        return true;
    }
}

