/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.repository.AGRepository;
import com.hp.hpl.jena.graph.Node;
import java.io.IOException;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.RepositoryException;

public class AGValueFactory
extends ValueFactoryImpl {
    private final AGRepository repository;
    private int blankNodeAmount = 100;
    private String[] blankNodeIds;
    private int index = -1;

    public AGValueFactory(AGRepository repository) {
        this.repository = repository;
        this.blankNodeIds = new String[this.blankNodeAmount];
    }

    public AGRepository getRepository() {
        return this.repository;
    }

    public AGHTTPClient getHTTPClient() {
        return this.getRepository().getHTTPClient();
    }

    private void getBlankNodeIds() {
        try {
            this.blankNodeIds = this.getHTTPClient().getBlankNodes(this.getRepository().getRepositoryURL(), this.blankNodeAmount);
            this.index = this.blankNodeIds.length - 1;
        }
        catch (UnauthorizedException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    String getNextBNodeId() {
        if (this.index == -1) {
            this.getBlankNodeIds();
        }
        String id = this.blankNodeIds[this.index];
        --this.index;
        return id.substring(2);
    }

    public BNode createBNode(String nodeID) {
        if (nodeID == null || "".equals(nodeID)) {
            nodeID = this.getNextBNodeId();
        }
        return super.createBNode(nodeID);
    }

    public BNode createBNode() {
        return this.createBNode(null);
    }

    public Value asValue(Node node) {
        URI val;
        if (node == null || node == Node.ANY) {
            val = null;
        } else if (node.isURI()) {
            val = this.createURI(node.getURI());
        } else if (node.isBlank()) {
            val = this.createBNode(node.getBlankNodeLabel());
        } else if (node.isLiteral()) {
            String lang = node.getLiteralLanguage();
            if (node.getLiteralDatatypeURI() != null) {
                URI datatype = this.createURI(node.getLiteralDatatypeURI());
                val = this.createLiteral(node.getLiteralLexicalForm(), datatype);
            } else {
                val = lang != null && !lang.equals("") ? this.createLiteral(node.getLiteralLexicalForm(), lang) : this.createLiteral(node.getLiteralLexicalForm());
            }
        } else {
            throw new IllegalArgumentException("Cannot convert Node to Value: " + node);
        }
        return val;
    }

    public Resource asResource(Node node) {
        URI res;
        if (node == null || node == Node.ANY) {
            res = null;
        } else if (node.isURI()) {
            res = this.createURI(node.getURI());
        } else if (node.isBlank()) {
            res = this.createBNode(node.getBlankNodeLabel());
        } else {
            throw new IllegalArgumentException("Cannot convert Node to Resource: " + node);
        }
        return res;
    }

    public URI asURI(Node node) {
        URI uri;
        if (node == null || node == Node.ANY) {
            uri = null;
        } else if (node.isURI()) {
            uri = this.createURI(node.getURI());
        } else if (node.isBlank()) {
            uri = this.createURI("http://anon/" + node.getBlankNodeLabel());
        } else {
            throw new IllegalArgumentException("Cannot convert Node to URI: " + node);
        }
        return uri;
    }
}

